
Module Nat_order Import Nat_more Monoid_order;

(* --------------------------------------------------------------------------------
   Define LessEq on naturals and prove it's a total ordering relation.
*)

[     lessEqN : nat->nat->Prop
          = nat_iter
            (nat\trueProp)
            ([ih:nat->Prop] nat_rec absurd ([n:nat]Prop\ih n))
]
[     LessEqN : Rel Nat Nat
          = QRel lessEqN
];

Goal LessEqN_antisym : AntiSymmetric LessEqN;
  Refine nat_double_elim [t,u:nat] (lessEqN t u)->(lessEqN u t)->Q t u;
  intros; Refine Q_refl;
  intros; Immed;
  intros; Immed;
  intros; Refine exten Succ; Refine n_ih; Immed;
Save;

Goal LessEqN_trans : Transitive LessEqN;
  Refine nat_double_elim [k,l:nat]{m:nat} (lessEqN k l) -> (lessEqN l m) -> lessEqN k m;
  intros; Immed;
  intros; Immed;
  intros; Immed;
  intros ____;
  Refine nat_ind [m:nat] (lessEqN (succ n) (succ n')) ->
                         (lessEqN (succ n') m) -> lessEqN (succ n) m;
  intros; Immed;
  intros; Refine n_ih; Immed;
Save;

Goal LessEqN_total : Total LessEqN;
  Refine nat_double_elim [k,l:el Nat] or (LessEqN.ap2 k l) (LessEqN.ap2 l k);
  Refine inr; Refine trueprf;
  intros; Refine inl; Refine trueprf;
  intros; Refine inr; Refine trueprf;
  intros; Refine n_ih n';
Save;

Goal Nat_total_order : TotallyOrdered LessEqN;
  Refine TotallyOrdered_intro;
  Refine LessEqN_antisym;
  Refine LessEqN_trans;
  Refine LessEqN_total;
Save;

[     LessEqN_refl : Reflexive LessEqN
          = LessEq_refl Nat_total_order
];

Goal LessEqN_LB : lowerbound LessEqN.ap2 ZeroN;
  Intros _;
  Refine trueprf;
Save;

Goal Plus_pres_LessEqN : preserve2 LessEqN.ap2 LessEqN.ap2 LessEqN.ap2 PlusN.ap2;
  Claim {a,x,y:nat} (lessEqN x y) -> (lessEqN (plusN x a) (plusN y a));
  Intros a b _ x y _;
  Refine LessEqN_trans; Refine (plusN b x); Refine ?1; Immed;
  Qrepl PlusN_commut b x;
  Qrepl PlusN_commut b y;
  Refine ?1; Immed;

  Refine nat_ind [a:nat]{x,y:nat} (lessEqN x y) -> (lessEqN (plusN x a) (plusN y a));
  intros; Immed;
  intros; Refine ih; Immed;
Save;

Goal Times_pres_LessEqN : preserve2 LessEqN.ap2 LessEqN.ap2 LessEqN.ap2 TimesN.ap2;
  Claim {a,x,y:nat} (lessEqN x y) -> (lessEqN (timesN x a) (timesN y a));
  Intros a b _ x y _;
  Refine LessEqN_trans; Refine (timesN b x); Refine ?1; Immed;
  Qrepl TimesN_commut b x; Qrepl TimesN_commut b y;
  Refine ?1; Immed;

  Refine nat_ind [a:nat]{x,y:nat} (lessEqN x y) -> (lessEqN (timesN x a) (timesN y a));
  intros; Refine LessEqN_refl;
  intros; Refine Plus_pres_LessEqN; Refine +1 ih; Immed;
Save;

Freeze LessEqN_LB Plus_pres_LessEqN Times_pres_LessEqN;

[     NatOMonoid : orderMonoid
          = orderMonoid_intro PlusN_assoc ZeroN_ident
                              Nat_total_order
                              LessEqN_LB Plus_pres_LessEqN
];

(* --------------------------------------------------------------------------------
   Define the less and less-equal relations.
*)

[     LessN : Rel Nat Nat
          = Nat_total_order.Less
];

Goal LessN_irrefl : Irreflexive LessN;
  Refine Nat_total_order.Less_irrefl;
Save;

Goal LessN_antisym : {k,l|el Nat} (LessN.ap2 k l) -> (LessN.ap2 l k) -> absurd;
  Refine Nat_total_order.Less_antisym;
Save;

[     LessLessEqN_trans : {x|el Nat}{y:el Nat}{z|el Nat}
                          (LessN.ap2 x y) -> (LessEqN.ap2 y z) -> (LessN.ap2 x z)
          = Nat_total_order.LessLessEq_trans
]
[     LessEqLessN_trans : {x|el Nat}{y:el Nat}{z|el Nat}
                          (LessEqN.ap2 x y) -> (LessN.ap2 y z) -> (LessN.ap2 x z)
          = Nat_total_order.LessEqLess_trans
];

Goal LessEq2LessN : {k,l|el Nat} (LessEqN.ap2 k l) -> ((Eq k l) \/ (LessN.ap2 k l));
  Refine Nat_total_order.LessEq2Less Nat_discr;
Save;

Goal LessEqN_dec : DecidableRel LessEqN;
  Refine Nat_total_order.LessEq_dec Nat_discr;
Save;

Goal LessEqN_partit : {k,l:el Nat} (LessEqN.ap2 k l) \/ (LessN.ap2 l k);
  Refine Nat_total_order.LessEq_partit Nat_discr;
Save;

Goal {phi|Prop} {x,y|el Nat} (LessEqN.ap2 x y) -> (LessN.ap2 y x) -> phi;
  intros; Refine H1.fst (LessEqN_antisym H1.snd H);
Save LessEqN_partit_ok;

Goal LessN_partit : {k,l:el Nat} or3 (LessN.ap2 k l) (Eq k l) (LessN.ap2 l k);
  Refine Nat_total_order.Less_partit Nat_discr;
Save;

Goal LessN_dec : DecidableRel LessN;
  Refine Nat_total_order.Less_dec Nat_discr;
Save;

Goal LessN_intro : {x,y|el Nat} ~(LessEqN.ap2 x y) -> LessN.ap2 y x;
  Refine Nat_total_order.Less_intro Nat_discr;
Save;

Goal LessEqN_intro : {x,y|el Nat} ~(LessN.ap2 x y) -> LessEqN.ap2 y x;
  Refine Nat_total_order.LessEq_intro Nat_discr;
Save;

Goal LessN_elim : {x,y|el Nat} (LessN.ap2 x y) -> ~(LessEqN.ap2 y x);
  Refine Nat_total_order.Less_elim;
Save;

Goal LessEqN_elim : {x,y|el Nat} (LessEqN.ap2 x y) -> ~(LessN.ap2 y x);
  Refine Nat_total_order.LessEq_elim;
Save;

(* --------------------------------------------------------------------------------
*)

Goal LessN_zero : {k|el Nat} ~(LessN.ap2 k ZeroN);
  intros;
  Refine LessEqN_elim; Refine LessEqN_LB;
Save;

Goal LessEqN_zero : {k|el Nat} (LessEqN.ap2 k ZeroN) -> Eq k ZeroN;
  intros;
  Refine LessEqN_antisym H; Refine LessEqN_LB;
Save;

Goal LessN_part_zero : {k:el Nat} (Eq k ZeroN) \/ (LessN.ap2 ZeroN k);
  intros;
  Refine LessN_partit k ZeroN;
  intros; Refine LessN_zero H;
  Refine inl;
  Refine inr;
Save;

(* --------------------------------------------------------------------------------
*)

Goal {x,y|el Nat} (LessEqN.ap2 x y) -> LessEqN.ap2 (Succ.ap x) (Succ.ap y);
  Intros ___; Refine H;
Save LessEqN_succ_pres;

Goal {x,y|el Nat} (LessN.ap2 x y) -> LessN.ap2 (Succ.ap x) (Succ.ap y);
  Refine Less_pres1 Nat_total_order Succ_inj LessEqN_succ_pres;
Save LessN_succ_pres;

Goal {x,y|el Nat} (LessEqN.ap2 (Succ.ap x) (Succ.ap y)) -> LessEqN.ap2 x y;
  intros; Refine H;
Save LessEqN_succ_inj;

Goal {x,y|el Nat} (LessN.ap2 (Succ.ap x) (Succ.ap y)) -> LessN.ap2 x y;
  Refine Nat_total_order.Less_inj LessEqN_succ_inj;
Save LessN_succ_inj;

(* --------------------------------------------------------------------------------
*)

Goal {x,y|el Nat} (LessN.ap2 x y) -> LessEqN.ap2 (Succ.ap x) y;
  Refine nat_double_elim [x,y:el Nat] (LessN.ap2 x y) -> LessEqN.ap2 (Succ.ap x) y;
  intros; Refine LessN_irrefl ? H;
  intros; Refine trueprf;
  intros; Refine LessN_zero H;
  intros; Refine n_ih; Refine LessN_succ_inj H;
Save LessN_elim_succ;

Goal {x,y|el Nat} (LessN.ap2 x (Succ.ap y)) -> LessEqN.ap2 x y;
  intros;
  Refine LessEqN_succ_inj;
  Refine LessN_elim_succ H;
Save LessEqN_intro_succ;

Goal {x,y|el Nat} (LessEqN.ap2 (Succ.ap x) y) -> LessN.ap2 x y;
  Refine nat_double_elim [x,y:el Nat] (LessEqN.ap2 (Succ.ap x) y) -> LessN.ap2 x y;
  intros; Refine H;
  intros; Refine pair; Intros _; Refine Succ_not_zero ? H1.Eq_sym; Refine LessEqN_LB;
  intros; Refine H;
  intros; Refine LessN_succ_pres; Refine n_ih; Refine H;
Save LessN_intro_succ;

Goal {x,y|el Nat} (LessEqN.ap2 x y) -> LessN.ap2 x (Succ.ap y);
  intros;
  Refine LessN_intro_succ;
  Refine LessEqN_succ_inj H;
Save LessEqN_elim_succ;

(* --------------------------------------------------------------------------------
*)

Goal LessEqN_succ : {x:el Nat} LessEqN.ap2 x (Succ.ap x);
  Refine nat_ind [x:el Nat] LessEqN.ap2 x (Succ.ap x);
  Refine trueprf;
  intros; Refine ih;
Save;

Goal LessN_succ : {x:el Nat} LessN.ap2 x (Succ.ap x);
  intros; Refine pair;
  Refine Succ_lemma1;
  Refine LessEqN_succ;
Save;

Goal LessEqN_succ_intro : {x,y|el Nat} (LessEqN.ap2 x y) -> LessEqN.ap2 x (Succ.ap y);
  intros;
  Refine LessEqN_trans ? H;
  Refine LessEqN_succ;
Save;

Goal LessEqN_succ_elim : {x,y|el Nat} (LessEqN.ap2 (Succ.ap x) y) -> LessEqN.ap2 x y;
  intros __; Refine LessEqN_succ_intro;
Save;

Goal LessN_succ_intro : {x,y|el Nat} (LessN.ap2 x y) -> LessN.ap2 x (Succ.ap y);
  intros;
  Refine LessEqN_elim_succ; Refine snd H;
Save;

Goal LessN_succ_elim : {x,y|el Nat} (LessN.ap2 (Succ.ap x) y) -> LessN.ap2 x y;
  intros;
  Refine LessN_intro_succ; Refine LessEqN_succ_elim; Refine LessN_elim_succ H;
Save;

(* --------------------------------------------------------------------------------
   Prove course value induction.

     ( \forall x . (\forall y<x . phi y) -> phi x)  ->  (\forall x . phi x)
*)

Goal CourseValueInduction
   : {phi:Nat.el->Prop} ({x:el Nat} ({y:el Nat} (LessN.ap2 y x) -> phi y) -> phi x) ->
                        {x:el Nat} phi x;
  intros _ ih z;
  Refine nat_ind [x:el Nat] {y:el Nat} (LessEqN.ap2 y x) -> phi y;
  Refine +3 LessEqN_refl;
  intros;
    Qrepl LessEqN_zero H;
    Refine ih; intros; Refine LessN_zero H1;
  intros x ih_x __;
    orE LessEq2LessN H;
    intros; Qrepl H1; Refine ih; intros; Refine ih_x; Refine LessEqN_intro_succ H2;
    intros; Refine ih_x; Refine LessEqN_intro_succ H1;
Save;

(* --------------------------------------------------------------------------------
*)

Goal LessEqN_cancelation : cancelation LessEqN.ap2 LessEqN.ap2 LessEqN.ap2 PlusN.ap2;
  andI;
  Intros; Refine ?4 a; Qrepl (PlusN_commut x a); Qrepl (PlusN_commut y a); Immed;
  Refine nat_ind [a:nat] {x,x':nat} (LessEqN.ap2 (plusN x a) (plusN x' a)) ->
                                     LessEqN.ap2 x x';
    intros; Immed;
    intros; Refine ih; Immed;
Save;

Goal r_cancelation LessN.ap2 LessN.ap2 PlusN.ap2;
  Intros ___;
  Refine nat_ind [a:el Nat]
            (LessN.ap2 (PlusN.ap2 x a) (PlusN.ap2 y a)) -> LessN.ap2 x y;
  Refine Id;
  intros; Refine ih; Refine LessN_succ_inj H;
Save rLessN_cancel;

Goal {x,y,a|el Nat} (LessN.ap2 x y) -> LessN.ap2 (PlusN.ap2 x a) (PlusN.ap2 y a);
  intros;
  Refine nat_ind [a:el Nat] LessN.ap2 (PlusN.ap2 x a) (PlusN.ap2 y a);
  Refine H;
  intros; Refine LessN_succ_pres; Refine ih;
Save rPlus_pres_LessN;

(* --------------------------------------------------------------------------------
   Define the less or equal by an existential quantification.
*)

[     lessEqN_Ex : Nat.el -> Nat.el -> Prop
          = [x,y:el Nat] Ex [z:el Nat] Eq (PlusN.ap2 x z) y
]
[     LessEqN_Ex : Rel Nat Nat
          = QRel lessEqN_Ex
];

Goal LessEqN_Ex_intro : {a,b|el Nat} (LessEqN.ap2 a b) -> (LessEqN_Ex.ap2 a b);
  Refine nat_double_elim [a,b:nat] (LessEqN.ap2 a b) -> LessEqN_Ex.ap2 a b;
  intros; Refine ExIntro; Refine ZeroN; Refine Eq_refl;
  intros; exI ?; Refine succ n'; Refine lZeroN_ident;
  intros; Refine LessN_zero H.LessN_intro_succ;
  intros; exE n_ih n' H; intros c _;
    exI ?; Refine c;
    Refine exten Succ H1; Refine lPlusSuccN;
Save;

Goal LessEqN_Ex_elim : {a,b|el Nat} (LessEqN_Ex.ap2 a b) -> (LessEqN.ap2 a b);
  Refine nat_double_elim [a,b:el Nat] (LessEqN_Ex.ap2 a b) -> (LessEqN.ap2 a b);
  intros; Refine trueprf;
  intros; Refine trueprf;
  intros; Refine H;
    intros c _; Refine Succ_not_zero (PlusN.ap2 n c);
      Refine Eq_trans (PlusN.ap2 (Succ.ap n) c) ?.Eq_sym H1; Refine lPlusSuccN;
  intros; Refine n_ih; Refine H; intros c _; Refine ExIntro; Refine c;
    Refine Succ_inj; Refine Eq_trans ? (lPlusSuccN ? ?).Eq_sym H1;
Save;

Goal LessEqN_Ex_total : Total LessEqN_Ex;
  Intros a b;
  Refine LessEqN_total a b;
  intros; Refine inl; Refine LessEqN_Ex_intro H;
  intros; Refine inr; Refine LessEqN_Ex_intro H;
Save;

Goal LessEqN_Ex_antisym : AntiSymmetric LessEqN_Ex;
  Intros a b __;
  Refine LessEqN_antisym; Refine LessEqN_Ex_elim H; Refine LessEqN_Ex_elim H1;
Save;

Goal LessEqN_Ex_dec : DecidableRel LessEqN_Ex;
  Intros i j;
  Refine LessEqN_Ex_total i j;
  intros; Refine inl; Refine H;
  intros; Refine Nat_discr i j;
  intros; Refine inl; Refine ExIntro; Refine ZeroN; Qrepl H1; Refine Eq_refl;
  intros; Refine inr; Intros _; Refine H1; Refine LessEqN_Ex_antisym H2 H;
Save;

Freeze LessEqN_Ex_dec;

(* ================================================================================
*)

Goal {x|el Nat} ~(Eq x ZeroN) -> LessN.ap2 x (DoubleN.ap x);
  Refine LessOMN_lemma3 NatOMonoid PlusN_cancel;
Save LessN_lemma3;

(* --------------------------------------------------------------------------------
   Define the minimum and maximum functions.
*)

[     MaxN : Fun2 Nat Nat Nat
          = Max Nat_total_order
]
[     MinN : Fun2 Nat Nat Nat
          = Min Nat_total_order
];

Goal MinN_lemma1 : {x,y:el Nat} LessEqN.ap2 (MinN.ap2 x y) x;
  Refine Min_lemma1l Nat_total_order;
Save;

Goal MaxN_idempot : Idempotent MaxN;
  Refine Max_idempot Nat_total_order;
Save;

Goal MaxN_assoc : Associative MaxN;
  Refine Max_assoc Nat_total_order;
Save;

Goal MaxN_commut : Commutative MaxN;
  Refine Max_commut Nat_total_order;
Save;

Goal MaxN_lemma1 : {x,y:el Nat} LessEqN.ap2 x (MaxN.ap2 x y);
  Refine Max_lemma1l Nat_total_order;
Save;

(* ================================================================================
   Define the set [0...p-1]
*)

[p : el Nat];

[     fin : SET
          = <n:el Nat> LessN.ap2 n p
]
[     fin_eq : fin -> fin -> Prop
          = [x,y:fin] Eq x.1 y.1
];

Goal reflexive fin_eq;
  Intros _;
  Refine Eq_refl;
Save fin_eq_refl;
  
Goal symmetric fin_eq;
  Intros __;
  Refine Eq_sym;
Save fin_eq_sym;
  
Goal transitive fin_eq;
  Intros ___;
  Refine Eq_trans;
Save fin_eq_trans;

[     Fin : Set
          = Set_intro fin_eq_refl fin_eq_sym fin_eq_trans
];

Discharge p;

Goal {x,y|el Nat} (LessEqN.ap2 y x) ->
     Eq (MinusN.ap2 (Succ.ap x) y) (Succ.ap (MinusN.ap2 x y));
  Refine nat_ind [x:el Nat] {y|el Nat} (LessEqN.ap2 y x) ->
     Eq (MinusN.ap2 (Succ.ap x) y) (Succ.ap (MinusN.ap2 x y));
  intros y _; Qrepl LessEqN_zero H; Refine Eq_refl;
  intros x ih_x;
  Refine nat_ind [y:el Nat] (LessEqN.ap2 y (Succ.ap x)) ->
     Eq (MinusN.ap2 (Succ.ap (Succ.ap x)) y) (Succ.ap (MinusN.ap2 (Succ.ap x) y));
  intros; Refine Eq_refl;
  intros y ih_y _; Refine ih_x H.LessEqN_succ_inj;
Save MinusN_lemma2;

(* --------------------------------------------------------------------------------
   Prove some continuity like result (needed in Prime).
*)

Goal {f|Fun Nat Nat}
     ({i:el Nat} LessN.ap2 (f.ap i) (f.ap (Succ.ap i))) ->
     ({x:el Nat} (LessEqN.ap2 (f.ap ZeroN) x) ->
                 Ex [i:el Nat] (LessEqN.ap2 (f.ap i) x) /\
                               (LessN.ap2 x (f.ap (Succ.ap i))));
  intros __;
  Refine nat_elim [x:el Nat] (LessEqN.ap2 (f.ap ZeroN) x) ->
        Ex [i:el Nat] (LessEqN.ap2 (f.ap i) x) /\ (LessN.ap2 x (f.ap (Succ.ap i)));

  (* Base case, take i = 0. *)
  intros; Refine ExIntro; Refine ZeroN;
  Refine pair H1;
  Refine LessEqLessN_trans; Refine +2 H;
  Qrepl LessEqN_zero H1; Refine LessEqN_refl;

  (* Induction step. *)
  intros; Refine LessEq2LessN H1;

  (* f(0) = S(n), take i = 0. *)
  intros; Refine ExIntro; Refine ZeroN;
  Refine pair H1;
  Qrepl H2.Eq_sym; Refine H;

  (* f(0) < S(n), so f(0) <= n. Apply ih. *)
  intros; Refine n_ih (LessEqN_intro_succ H2); intros j _;
  Refine LessEq2LessN H3.snd.LessN_elim_succ;

  (* S(n) = f(S(j)), take i = S(j). *)
  intros; Refine ExIntro; Refine Succ.ap j;
    Qrepl H4; Refine pair; Refine LessEqN_refl; Refine H;

  (* S(n) < f(S(j)), take i = j. *)
  intros; Refine ExIntro; Refine j;
    Refine pair ? H4; Refine LessEqN_trans ? H3.fst; Refine LessEqN_succ;

Save monotone_increasing_lemma;
