
Module List Import Nat Pred case;

(* Define the type of list by induction and provide some recursor/iterators. *)

Inductive [list : SET]
Parameters [S : SET]
Constructors [nil : list] [cons' : S -> list -> list];
Discharge S;

[S | SET];

[     cons : S -> (list S) -> (list S)
          = cons' S
];

[     list_rec [T|TYPE] : T -> ({x:S}{l:list S}{ih:T}T) -> (list S) -> T 
          = list_elim S (list S)\T
]
[     list_iter [T|TYPE] [x:T] [f:{x:S}{ih:T}T] : (list S) -> T
          = list_rec x ([y:S](list S)\f y)
]
[     list_ind [P:(list S) -> Prop]
            : (P (nil S)) -> ({x:S}{l:list S}{ih:P l} P (cons x l)) -> {l:list S} P l
            = list_elim S P
];

Goal {phi:(list S)->TYPE}
     (phi (nil S)) ->
     ({x:S} phi (cons x (nil S))) ->
     ({x,y|S}{l|list S}(phi (cons y l)) -> phi (cons x (cons y l))) ->
     {l:list S} phi l;
  intros _____;
  Refine list_elim ? phi; Refine H;
  intros x; Refine list_elim ? [l:list S] (phi l) -> phi (cons x l);
  intros; Refine H1;
  intros y l H3 H4; Refine H2 H4;
Save list_elim_elim;

Discharge S;

Goal {T,U|SET}
     {psi:(list T)->(list U)->TYPE}
     (psi (nil T) (nil U)) ->
     ({u:U}{m:list U}(psi (nil T) m) -> psi (nil T) (cons u m)) ->
     ({t:T}{l:list T}({m:list U}psi l m) -> psi (cons t l) (nil U)) ->
     ({t:T}{l:list T}({m:list U}psi l m) ->
                     {u:U}{m:list U}(psi (cons t l) m) ->
                     psi (cons t l) (cons u m)) ->
     {l:list T}{m:list U} psi l m;
  Intros _______;
  Refine list_elim ? [l:list T]{m:list U}psi l m;
  Refine list_elim ? (psi (nil T)) H H1;
  Intros x l ih;
  Refine list_elim ? (psi (cons x l)) (H2 ? ? ih) (H3 ? ? ih);
Save list_elim2;

Goal list_double_elim
      : {S|SET}{phi:S.list->S.list->TYPE}
        (phi S.nil S.nil) ->
        ({x:S}{l:list S} (phi S.nil l) -> phi S.nil (cons x l)) ->
        ({x:S}{l:list S}({m:list S} phi l m) -> phi (cons x l) S.nil) ->
        ({x:S}{l:list S}({m:list S} phi l m) ->
         {y:S}{m:list S}(phi (cons x l) m)->phi (cons x l) (cons y m)) ->
        {z,z':list S}phi z z';
  intros _;
  Refine list_elim2;
Save;

(* --------------------------------------------------------------------------------
   Define useful operations concerning lists.
*)

[T,U | SET];

[     singletonL [x:T] : list T
          = cons x (nil T)
];

[     head [err:T] : (list T) -> T
          = list_iter err ([a:T][ih:T] a)
]
[     tail : (list T) -> list T
          = list_rec (nil T) ([a:T][l:list T][ih:list T] l)
];

[     concat : (list T) -> (list T) -> (list T)
          = [m1,m2:list T] list_iter m2 (cons|T) m1
];

[     append : (list T) -> T -> list T
          = [m:list T][x:T] concat m (cons x T.nil)
];

[     length : (list T) -> nat
          = list_iter ZeroN (T\succ)
];

[     nth [err:T] [l:list T] [n:nat] : T
          = nat_rec (head err) ([_:nat][ih:(list T)->T][l:list T] ih (tail l)) n l
];

(* -------------------------------------------------------------------------------- *)

Goal {l|list T} (Q (length l) ZeroN) -> Q l (nil T);
  Refine list_elim ? [l|list T] (Q (length l) ZeroN) -> Q l (nil T);
  intros _; Refine Q_refl;
  intros; Refine Succ_not_zero ? H;
Save length_zero;

Goal {p|list T} {n|nat} (Q (length p) (succ n)) -> Ex2 [x:T][l:list T] Q p (cons x l);
  intros __;
  Refine list_elim ? [l|list T] (Q (length l) (succ n))->
                              Ex2 ([x:T][m:list T] Q l (cons x m));
  intros; Refine Succ_not_zero; Refine +1 H.Q_sym;
  intros; Refine Ex2Intro; Refine +2 Q_refl;
Save length_succ;

Goal {err,t,u:T}{l:list T}{n|el Nat} ~(Eq n ZeroN) ->
     Q (nth err (cons t l) n) (nth err (cons u l) n);
  intros ____;
  Refine nat_ind [n:el Nat] ~(Eq n ZeroN) ->
                             Q (nth err (cons t l) n) (nth err (cons u l) n);
  intros; Refine H; Refine Eq_refl;
  intros; Refine Q_refl;
Save nth_lemma1;

(* ----------------------------------------------------------------------
   Define some more operators on lists.
*)

[     mapL [f:T->U] : (list T) -> list U
          = list_iter (nil U) ([a:T]cons (f a))
]
[     opL [o:U->T->T] [id:T] : (list U) -> T
          = list_iter id o
];

DischargeKeep T;

[     orL  : (list Prop) -> Prop
          = opL or absurd
]
[     andL : (list Prop) -> Prop
          = opL and trueProp
];

[     predL [P : T -> Prop] : (list T) -> Prop
          = [l:list T] andL (mapL P l)
];

Discharge T;

(* ================================================================================
   Given a set A. Define the set (List A) as a list of elements of A.
   Take for the equivalence relation pairwise equality on every member
   of the two lists.
*)

[A | Set];

(*
   nil = nil              ==>  true
   nil = cons x l         ==>  false
   cons = nil             ==>  false
   cons x l = cons y k    ==>  l = k
*)

[     Eq_list : (list A.el) -> (list A.el) -> Prop
          = list_elim2 (A.el.list\A.el.list\Prop)
                       trueProp
                       ([u:A.el][m:list A.el][ih_m:Prop] absurd)
                       ([t:A.el][l:list A.el][ih_l:(list A.el)->Prop] absurd)
                       ([t:A.el][l:list A.el][ih_l:(list A.el)->Prop]
                        [u:A.el][m:list A.el][ih_m:Prop] and (Eq t u) (ih_l m))
];

Goal reflexive Eq_list;
  Refine list_ind ([l:list A.el] Eq_list l l);
  Refine trueprf;
  intros __; Refine pair ?.Eq_refl;
Save Eq_list_refl;

Goal symmetric Eq_list;
  Refine list_elim2 [l,m:list A.el] (Eq_list l m) -> Eq_list m l;
  Refine Id;
  intros ___; Refine Id;
  intros ___; Refine Id;
  intros; Refine pair H2.fst.Eq_sym (H ? H2.snd);
Save Eq_list_sym;

Goal transitive Eq_list;
  Refine list_elim2 [a,b:list A.el] {c:list A.el}
                     (Eq_list a b) -> (Eq_list b c) -> Eq_list a c;
  intros __; Refine Id;
  intros _____; Refine H1;
  intros _____; Refine H1;
  intros x k ih_k y l ih_l;
  Refine list_ind [m:list A.el] (Eq_list (cons x k) (cons y l)) ->
                                (Eq_list (cons y l) m) -> Eq_list (cons x k) m;
  intros _; Refine Id;
  intros z m ih_m __; Refine pair (Eq_trans ? H.fst H1.fst) (ih_k ? ? H.snd H1.snd);
Save Eq_list_trans;

Discharge A;

[     List [A:Set] : Set
          = Set_intro (Eq_list_refl|A) (Eq_list_sym|A) (Eq_list_trans|A)
];

(* --------------------------------------------------------------------------------
   Redefine a number of previously defined operations over list as functions.
*)

[A | Set];

Goal extensional2|A|(List A)|A (head|A.el);
  Intros a b _ l m _;
  Refine list_elim2 [l,m:(List A).el] (Eq l m) -> Eq (head a l) (head b m);
  intros; Refine H;
  intros; Refine H3;
  intros; Refine H3;
  intros; Refine fst H4;
  Refine H1;
Save head_exten;

Goal extensional|(List A)|(List A) (tail|A.el);
  Refine list_elim2 [l,l':(List A).el] (Eq l l') -> Eq|(List A) (tail l) (tail l');
  intros; Refine trueprf;
  intros; Refine H1;
  intros; Refine H1;
  intros; Refine snd H2;
Save tail_exten;

Goal extensional3|A|(List A)|Nat|A (nth|A.el);
  Intros a b _ l l' _ x x' _;
  Qrepl H2;
  Refine nat_ind [x':nat] {l,l':(List A).el} (Eq l l') ->
                           Eq (nth a l x') (nth b l' x');
  intros; Refine head_exten H H3;
  intros; Refine ih; Refine tail_exten H3;
  Refine H1;
Save nth_exten;

Goal extensional2|(List A)|A|(List A) (append|A.el);
  Intros l l' _ x x' _;
  Refine list_elim2 [l,l':(List A).el] (Eq l l') ->
                                       Eq|(List A) (append l x) (append l' x');
  intros; Refine pair H1 trueprf;
  intros; Refine H3;
  intros; Refine H3;
  intros; Refine pair H4.fst; Refine H2 ? H4.snd;
  Refine H;
Save append_exten;

[     Head : Fun2 A (List A) A 
          = Fun2_intro ? head_exten
]
[     Tail : Fun (List A) (List A)
          = Fun_intro ? tail_exten
]
[     Nth : Fun3 A (List A) Nat A
          = Fun3_intro ? nth_exten
]
[     Append : Fun2 (List A) A (List A)
          = Fun2_intro (append|A.el:(List A).el->A.el->(List A).el) append_exten
];

(* --------------------------------------------------------------------------------
*)

Goal {x,y|el A} (Eq x y) -> {l,m|el (List A)} (Eq l m) -> Eq_list (cons x l) (cons y m);
  intros _____;
  Refine pair H;
Save Eq_list_intro;

[     epsL [t:el A] : (list A.el) -> Prop
          = list_elim ? (A.el.list\Prop)
                        absurd
                        ([a:A.el][l:list A.el][ih:Prop] or (Eq t a) ih)
];

[     filter [phi|Pred A][A_dec:DecidablePred phi] : (List A).el -> (List A).el
          = list_iter (nil A.el)
                      ([x:A.el][ih:(List A).el] select (A_dec x) (cons x ih) ih)
];

Discharge A;
