
Module IndexMonoid Import Monoid Nat Nat_order;

(* --------------------------------------------------------------------------------
   An indexMonoid is a abelian monoid with the cancelation law. It is

    -   ordered to be able to define a degree
    -   discrete to be able to define have a maximum and like.

*)

Goal axiomsIMN : Axioms sigOMN;
  Refine Axioms_intro;
  Intros A IC IP;
  Zero   == (IC star21).apn : el A;
  Plus   == IC star22       : Fun2 A A A;
  LessEq == IP star         : Rel A A;
  Refine and9 (Associative Plus) (Identity Plus Zero)
              (TotallyOrdered LessEq)
              (LessEq_resp_One LessEq Zero) (LessEq_resp_Times LessEq Plus)
              (Discrete A)
              (Commutative Plus) (Cancelation Plus)
              (DecidableRel Plus.rLessEq);
Save;

[     indexMonoid
          = Model axiomsIMN
];

Goal indexMonoid_intro
   : {A|Set} {Plus|Fun2 A A A} {Zero|el A} {LessEq|Rel A A}
     {A_discr        : Discrete A}
     {Plus_assoc     : Associative Plus}
     {Plus_commut    : Commutative Plus}
     {rPlus_cancel   : rCancelation Plus}
     {rZero_ident    : rIdentity Plus Zero}
     {LE_total_order : TotallyOrdered LessEq}
     {LE_Zero        : LessEq_resp_One LessEq Zero}
     {LE_Plus        : LessEq_resp_Times LessEq Plus}
     {rLessEq_dec    : DecidableRel Plus.rLessEq}
     indexMonoid;
  intros;
  Refine Model_intro;
  Refine A;
  Refine TwoSET_elim [c:FuncSymb sigOMN] nFunc A (FuncArity c);
    Refine constant Zero;
    Refine Plus;
  Refine UnitSET_elim [p:PredSymb sigOMN] nPred A (PredArity p);
    Refine LessEq;
  Refine pair9 Plus_assoc ?
               LE_total_order LE_Zero LE_Plus
               A_discr
               Plus_commut ? rLessEq_dec;
  Refine Identity_intro Plus_commut rZero_ident;
  Refine Cancelation_intro Plus_commut rPlus_cancel;
Save;

(* --------------------------------------------------------------------------------
   Let IMN be an index monoid. Define functions to extract all components of IMN.
*)

[IMN : indexMonoid];
  [ZeroIMN           : obj IMN               = intCons IMN star21]
  [PlusIMN           : BFunMdl IMN           = intFunc IMN star22]
  [LessEqIMN         : BRelMdl IMN           = intPred IMN star  ];

  [PlusIMN_assoc     : Associative PlusIMN                  = and9_out1 IMN.axioms]
  [ZeroIMN_ident     : Identity PlusIMN ZeroIMN             = and9_out2 IMN.axioms]
  [IMN_total_order   : TotallyOrdered LessEqIMN             = and9_out3 IMN.axioms]
  [LessEqIMN_zero    : LessEq_resp_One LessEqIMN ZeroIMN    = and9_out4 IMN.axioms]
  [LessEqIMN_plus    : LessEq_resp_Times LessEqIMN PlusIMN  = and9_out5 IMN.axioms]
  [indexMonoid_discr : Discrete IMN.car                     = and9_out6 IMN.axioms]
  [PlusIMN_commut    : Commutative PlusIMN                  = and9_out7 IMN.axioms]
  [PlusIMN_cancel    : Cancelation PlusIMN                  = and9_out8 IMN.axioms]
  [rLessEqIMN_dec'   : DecidableRel PlusIMN.rLessEq         = and9_out9 IMN.axioms];

Freeze ZeroIMN PlusIMN LessEqIMN;

  Goal orderMonoidIMN : orderMonoid;
    Refine orderMonoid_intro PlusIMN_assoc ZeroIMN_ident IMN_total_order;
    Refine LessEqIMN_zero;
    Refine LessEqIMN_plus;
  Save;

  [MonoidIMN         : Monoid                   = MonoidOMN orderMonoidIMN];

  [LessIMN           : BRelMdl IMN              = IMN_total_order.Less];

  [LessEqIMN_refl    : Reflexive LessEqIMN      = IMN_total_order.LessEq_refl]
  [LessEqIMN_antisym : AntiSymmetric LessEqIMN  = IMN_total_order.LessEq_antisym]
  [LessEqIMN_trans   : Transitive LessEqIMN     = IMN_total_order.LessEq_trans]
  [LessEqIMN_total   : Total LessEqIMN          = IMN_total_order.LessEq_total];

  [rZeroIMN_ident    : rIdentity PlusIMN ZeroIMN = MonoidIMN.rOneMN_ident]
  [lZeroIMN_ident    : lIdentity PlusIMN ZeroIMN = MonoidIMN.lOneMN_ident];

  [rPlusIMN_cancel   : rCancelation PlusIMN      = snd PlusIMN_cancel]
  [lPlusIMN_cancel   : lCancelation PlusIMN      = fst PlusIMN_cancel];

  [rLessEqIMN        : BRelMdl IMN               = MonoidIMN.rLessEqMN]
  [lLessEqIMN        : BRelMdl IMN               = MonoidIMN.lLessEqMN];

  Goal LessEqIMN_partit : {x,y:obj IMN} (LessEqIMN.ap2 x y) \/ (LessIMN.ap2 y x);
    Refine LessEq_partit IMN_total_order indexMonoid_discr;
  Save;

  Goal rLessEqIMN_dec : DecidableRel rLessEqIMN;
    Equiv DecidableRel PlusIMN.rLessEq;
    Refine rLessEqIMN_dec';
  Save;

  Goal lLessEqIMN_dec : DecidableRel lLessEqIMN;
    Refine lLessEqMN_dec_intro MonoidIMN PlusIMN_commut rLessEqIMN_dec;
  Save;

  Goal {x,y:obj IMN} LessEqIMN.ap2 x (PlusIMN.ap2 x y);
    Refine orderMonoidIMN.rLessEqOMN_lemma1;
  Save rLessEqIMN_lemma1;

  Goal {x,y:obj IMN} LessEqIMN.ap2 x (PlusIMN.ap2 y x);
    Refine orderMonoidIMN.lLessEqOMN_lemma1;
  Save lLessEqIMN_lemma1;

  Goal {x|obj IMN} ~(Eq x ZeroIMN) -> (LessIMN.ap2 ZeroIMN x);
    Refine orderMonoidIMN.LessOMN_lemma1;
  Save LessIMN_lemma1;

  Goal {x:obj IMN}{y|obj IMN} (LessIMN.ap2 x y) -> ~(Eq y ZeroIMN);
    Refine orderMonoidIMN.LessOMN_lemma2;
  Save LessIMN_lemma2;

  Goal r_cancelation LessEqIMN.ap2 LessEqIMN.ap2 PlusIMN.ap2;
    Refine orderMonoidIMN.rLessEqOMN_cancel PlusIMN_cancel;
  Save rLessEqIMN_cancel;

  Goal l_cancelation LessEqIMN.ap2 LessEqIMN.ap2 PlusIMN.ap2;
    Refine orderMonoidIMN.lLessEqOMN_cancel PlusIMN_cancel;
  Save lLessEqIMN_cancel;

  Goal {x,x',y,y'|IMN.obj} (LessEqIMN.ap2 (PlusIMN.ap2 x x') (PlusIMN.ap2 y y')) ->
                           ((LessEqIMN.ap2 x y) \/ (LessEqIMN.ap2 x' y'));
    Refine orderMonoidIMN.LessEqOMN_cancel PlusIMN_cancel;
  Save LessEqIMN_cancel;

  Goal {x,y|obj IMN}{a:obj IMN} (LessIMN.ap2 x y) ->
       LessIMN.ap2 (PlusIMN.ap2 x a) (PlusIMN.ap2 y a);
    Refine orderMonoidIMN.rLessOMN_times PlusIMN_cancel;
  Save rLessIMN_plus;

  Goal {x,y|obj IMN}{a:obj IMN} (LessIMN.ap2 x y) ->
       LessIMN.ap2 (PlusIMN.ap2 a x) (PlusIMN.ap2 a y);
    Refine orderMonoidIMN.lLessOMN_times PlusIMN_cancel;
  Save lLessIMN_plus;

  Goal preserve2 LessIMN.ap2 LessIMN.ap2 LessIMN.ap2 PlusIMN.ap2;
    Refine orderMonoidIMN.LessOMN_times PlusIMN_cancel;
  Save LessIMN_plus;

  Goal {x,y|obj IMN} (Eq (PlusIMN.ap2 x y) ZeroIMN) -> ((Eq x ZeroIMN) /\ (Eq y ZeroIMN));
    Refine orderMonoidIMN.OneOMN_lemma1;
  Save ZeroIMN_lemma1;

(* -------------------------------------------------------------------------------- *)

  Goal {x,x',y,y'|obj IMN} (LessEqIMN.ap2 x x') -> (LessEqIMN.ap2 y y') ->
                           (Eq (PlusIMN.ap2 x y) (PlusIMN.ap2 x' y')) ->
                           ((Eq x x') /\ (Eq y y'));
    intros; Refine pair;
    Refine rPlusIMN_cancel y;
    Refine Eq_trans (PlusIMN.ap2 x' y'); Refine H2;
    Refine exten2 ? ?.Eq_refl; Refine Eq_sym ?+1;
    Refine lPlusIMN_cancel x';
    Refine LessEqIMN_antisym;
    Refine LessEqIMN_plus ?.LessEqIMN_refl H1;
    Refine extenRel ? H2 ?.Eq_refl;
    Refine LessEqIMN_plus H ?.LessEqIMN_refl;
  Save IMN_lemma1;

  Goal {x,y|obj IMN} (rLessEqIMN.ap2 x y) -> (LessEqIMN.ap2 x y);
    intros;
    orE LessEqIMN_total x y; Refine Id;
    intros;
    exE H; intros k _;
    Refine extenRel ? ?.rZeroIMN_ident H2;
    Refine LessEqIMN_plus ?.LessEqIMN_refl;
    Refine LessEqIMN_zero;
  Save rLessEqIMN_lemma2;

  Goal {x,y|obj IMN} (rLessEqIMN.ap2 x y) \/ {k:obj IMN} ~(Eq (PlusIMN.ap2 x k) y);
    intros;
    orE rLessEqIMN_dec x y; Refine inl;
    intros; Refine inr;
    Intros __; Refine H;
    Refine ExIntro; Refine +1 H1;
  Save rLessEqIMN_dec2;

Discharge IMN;

(* ----------------------------------------------------------------------
   The natural numbers form an index monoid.
*)

Goal NatIMonoid : indexMonoid;
  Refine indexMonoid_intro Nat_discr;
  Refine +3 PlusN_assoc;
  Refine +2 PlusN_commut;
  Refine +2 rPlusN_cancel;
  Refine +2 rZeroN_ident;
  Refine +1 Nat_total_order;
  Refine LessEqN_LB;
  Refine Plus_pres_LessEqN;
  Refine LessEqN_Ex_dec;
Save;

(* ---------------------------------------------------------------------- 
   Let I be a index monoid, and n be a natural number.
   I^n is also an index moniod.
*)

[A | Set] [LessEq : Rel A A];

Goal nlesseq : {n:nat} (Product A n).el -> (Product A n).el -> Prop;
  Refine nat_elim_01 [n:nat] (Product A n).el -> (Product A n).el -> Prop;
  Intros __; Refine trueProp;
  Refine LessEq.ap2;
  Intros n ih v v';
  [t = first v] [t' = first v'];
  Refine and (LessEq.ap2 t t') ((Eq t t') -> ih v.second v'.second);
Save;

Goal nlesseq_exten : {n:nat} extensionalRel (nlesseq n);
  Refine nat_elim_01 [n:nat] extensionalRel (nlesseq n);
  Intros ______; Refine trueprf;
  Refine extenRel LessEq;
  Intros n' n_ih _______;
  Refine H; Refine H1; Refine H2; intros; Refine pair;
  Refine extenRel LessEq H7 H5 H3;
  intros; Refine n_ih H8 H6 (H4 ?);
  Refine Eq_trans x'.first; Refine H7;
  Refine Eq_trans y'.first; Refine H9; Refine H5.Eq_sym;
Save;

Goal nLessEq : {n:nat} Rel (Product A n) (Product A n);
  intros;
  Refine Rel_intro;
  Refine +1 nlesseq_exten;
Save;

Discharge LessEq;

[A_discr : Discrete A];

[LessEq | Rel A A] [TO : TotallyOrdered LessEq];

Goal nLessEq_antisym : {n:nat} AntiSymmetric (nLessEq LessEq n);
  Refine nat_elim_01 [n:nat] AntiSymmetric (nLessEq LessEq n);
  Intros ____; Refine Product_zero;
  Refine LessEq_antisym TO;
  Intros n ih v v' __; Refine H; Refine H1; intros; Refine pair;
  Refine +1 ih (H5 ?) (H3 ?); Refine ?+1; Refine +1 ?+0.Eq_sym;
  Refine TO.LessEq_antisym H4 H2;
Save;

Goal nLessEq_trans : {n:nat} Transitive (nLessEq LessEq n);
  Refine nat_elim_01 [n:nat] Transitive (nLessEq LessEq n);
  Intros _____; Refine trueprf;
  Refine LessEq_trans TO;
  Intros n ih u v w __;
  Refine H; Refine H1; intros; Refine pair;
  Refine TO.LessEq_trans ? H4 H2;
  intros; Refine ih ? (H5 ?) (H3 ?);
  Refine TO.LessEq_antisym H4; Refine extenRel ? ? H6.Eq_sym H2; Refine Eq_refl;
  Refine TO.LessEq_antisym H2; Refine extenRel ? H6 ? H4; Refine Eq_refl;
Save;

Goal nLessEq_total : {n:nat} Total (nLessEq LessEq n);
  Refine nat_elim_01 [n:nat] Total (nLessEq LessEq n);
  Intros __; Refine inl; Refine trueprf;
  Refine LessEq_total TO;
  Intros n ih v v'; [t = first v] [t' = first v'];
  [w = second v] [w' = second v'];
  Refine A_discr t t';
  intros; Refine ih w w';
  intros; Refine inl; Refine pair;
    Refine extenRel ? ? H; Refine +1 Eq_refl; Refine TO.LessEq_refl;
    intros; Refine H1;
  intros; Refine inr; Refine pair;
    Refine extenRel ? H; Refine +1 Eq_refl; Refine TO.LessEq_refl;
    intros; Refine H1;
  intros; Refine TO.LessEq_total t t';
  intros; Refine inl; Refine pair H1; intros; Refine H H2;
  intros; Refine inr; Refine pair H1; intros; Refine H H2.Eq_sym;
Save;

[     nTotallyOrdered : {n:nat} TotallyOrdered (nLessEq LessEq n)
          = [n:nat] TotallyOrdered_intro n.nLessEq_antisym
                                         n.nLessEq_trans
                                         n.nLessEq_total
];

Discharge A;

[IMN : indexMonoid];

Goal nLessEq_zero
   : {n:nat} LessEq_resp_One (nLessEq IMN.LessEqIMN n) (el_n IMN.ZeroIMN n);
  Refine nat_elim_01 [n:nat] LessEq_resp_One (nLessEq IMN.LessEqIMN n)
                                             (el_n IMN.ZeroIMN n);
  Intros _; Refine trueprf;
  Refine LessEqIMN_zero;
  Intros n ih v;
  Refine pair; Refine LessEqIMN_zero; intros; Refine ih;
Save;

Goal nLessEq_plus
   : {n:nat} LessEq_resp_Times (nLessEq IMN.LessEqIMN n) (Map2P IMN.PlusIMN n);
  Refine nat_elim_01 [n:nat] LessEq_resp_Times (nLessEq IMN.LessEqIMN n)
                                               (Map2P IMN.PlusIMN n);
  Intros ______; Refine trueprf;
  Refine LessEqIMN_plus;
  Intros n ih v v' _ w w' _;
  Refine H; Refine H1; intros;
  Refine pair; Refine LessEqIMN_plus; Refine H4; Refine H2;
  intros; Refine IMN_lemma1 IMN H4 H2 H6;
  intros; Refine ih; Refine H5 H7; Refine H3 H8;
Save;

Goal nat -> indexMonoid;
  intros n;
  Refine indexMonoid_intro;
  Refine +4 Product_discr IMN.indexMonoid_discr n;
  Refine +3 Map2P_assoc IMN.PlusIMN_assoc n;
  Refine +2 Map2P_commut IMN.PlusIMN_commut n;
  Refine +2 Map2P_cancel IMN.rPlusIMN_cancel n;
  Refine +2 el_n_ident IMN.rZeroIMN_ident;
  Refine +1 nTotallyOrdered IMN.indexMonoid_discr IMN.IMN_total_order n;
  Refine nLessEq_zero;
  Refine nLessEq_plus;
  Refine Map2P_rLessEq_dec IMN.rLessEqIMN_dec;
Save n_indexMonoid;

Discharge IMN;

Unfreeze ZeroIMN PlusIMN LessEqIMN;
(* Freeze ZeroIMN PlusIMN LessEqIMN; *)

