
Module Group_sub Import Group_homo;

(* Define the notion of subgroup. *)

[    subgroup : {G|Group} (Subset G.car) -> Prop
          = submodel|sigGr|axiomsGr
];

[G | Group];

[     subgroup_intro :
              {P|Subset G.car}
              (P.ap G.OneGr) ->
              ({x|obj G} (P.ap x) -> P.ap (G.InvGr.ap x)) ->
              ({x|obj G} (P.ap x) -> {y|obj G} (P.ap y) -> P.ap (G.TimesGr.ap2 x y)) ->
              subgroup P
          = [P|Subset G.car] ThreeSET_elim (submodel_axiom P)
];

[P | Subset G.car] [subGr : subgroup P]

[    subgroup_one : P.ap G.OneGr
          = subGr star31
]
[    subgroup_inv : {x|obj G} (P.ap x) -> P.ap (G.InvGr.ap x)
          = subGr star32
]
[    subgroup_times : {x|obj G} (P.ap x) -> {y|obj G} (P.ap y) ->
                      P.ap (G.TimesGr.ap2 x y)
          = subGr star33
];

Freeze OneGr InvGr TimesGr;

(* --------------------------------------------------------------------------------
   A subgroup H of G is normal if

              h \elem H  ->  (g+h)-g \elem H
*)

[    normalSubgroup [P:Subset G.car] : Prop
          = (subgroup P) /\
            {h|obj G} (P.ap h) -> {g:obj G}
            P.ap (G.DivGr.ap2 (G.TimesGr.ap2 g h) g)
];

[nsubGr : normalSubgroup P];

[    normalSubgroup_subgroup : subgroup P
          = fst nsubGr
]
[    normalSubgroup_ax : {h|obj G} (P.ap h) -> {g:obj G}
            P.ap (G.TimesGr.ap2 (G.TimesGr.ap2 g h) (G.InvGr.ap g))
          = snd nsubGr
];

Discharge P;

(* --------------------------------------------------------------------------------
   Define the kernel of a homomorphism h as  { x | h(x) = 0 }
*)

[G' | Group] [h : Homomorphism G G'];

[    kernelGr : Subset G.car
          = kernel h G'.OneGr
];

(* Prove that the kernel of h forms a subgroup. *)

Goal subgroup kernelGr;
  Refine subgroup_intro;
  Refine HomoGr_one;

  intros;
  Refine Eq_trans (G'.InvGr.ap (h.Homo_f.ap x));
    Refine HomoGr_inv;
  Refine Eq_trans (G'.InvGr.ap G'.OneGr);
    Refine exten ? H;
  Refine InvOneGr;

  intros;
  Refine Eq_trans (G'.TimesGr.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y));
    Refine HomoGr_times;
  Refine Eq_trans (G'.TimesGr.ap2 G'.OneGr G'.OneGr);
    Refine exten2 ? H H1;
  Refine rOneGr_ident;
Save KernelGr_subgroup;

(* Prove that the kernel of h forms a normal subgroup. *)

Goal normalSubgroup kernelGr;
  Refine pair;
  Refine KernelGr_subgroup;
  intros y H x;
  f == h.Homo_f.ap;
  Refine Eq_trans (G'.TimesGr.ap2 (f (G.TimesGr.ap2 x y)) (f (G.InvGr.ap x)));
    Refine HomoGr_times;
  Refine Eq_trans (G'.DivGr.ap2 (f x) (f x));
    Refine +1 rInvGr_invers;
  Refine exten2; Refine +1 HomoGr_inv;
  Refine Eq_trans (G'.TimesGr.ap2 (f x) (f y));
    Refine HomoGr_times;
  Refine Eq_trans (G'.TimesGr.ap2 (f x) G'.OneGr);
    Refine exten2 ? ?.Eq_refl H;
  Refine rOneGr_ident;
Save KernelGr_normalSubgroup;

(* Prove

           a-b \elem kernel(h)  <->  h(a) = h(b)
*)

Goal {a,b:obj G}
     iff (kernelGr.ap (G.DivGr.ap2 a b)) (Eq (h.Homo_f.ap a) (h.Homo_f.ap b));
  intros;
  i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2; f == h.Homo_f.ap;
  Refine pair;

  intros; Refine DivGr_lemma1;
  Refine Eq_trans (f (m a b)) ? H;
  Refine Eq_trans (G'.TimesGr.ap2 (f a) (f (i b)));
    Refine exten2 G'.TimesGr ?.Eq_refl;
    Refine Eq_sym; Refine HomoGr_inv;
  Refine Eq_sym; Refine HomoGr_times;

  intros;
  Equiv Eq (f (m a b)) G'.OneGr;
  Refine Eq_trans (G'.TimesGr.ap2 (f a) (f (i b)));
    Refine HomoGr_times;
  Refine Eq_trans (G'.DivGr.ap2 (f a) (f b));
    Refine exten2 ??.Eq_refl; Refine HomoGr_inv;
  Refine Eq_trans (G'.DivGr.ap2 (f a) (f a));
    Refine exten2 ??.Eq_refl H.Eq_sym;
  Refine rInvGr_invers;
Save kernelGr_lemma;

Discharge G;

Unfreeze OneGr InvGr TimesGr;

