
Module Group_quot Import Group_homo Group_sub;

(* Let G, G' be a group, H be a normal subgroup of G. *)

[G,G' | Group];

[H | Subset G.car] [H_normalSubgroup : normalSubgroup H];

$[H_subgroup : subgroup H = normalSubgroup_subgroup H_normalSubgroup];

(* Define G/H as the set whose elements are precisely the elements of G,
   but equality is defined by setting a = b if a-b \elem H.
*)

[Eq_quotGr : G.obj -> G.obj -> Prop = [x,y:obj G] H.ap (G.DivGr.ap2 x y)];

(* Show that this relation is an equality relation indeed. *)

Goal reflexive Eq_quotGr;
  Intros;
  Refine extenPred; Refine OneGr;
  Refine Eq_sym; Refine rInvGr_invers;
  Refine subgroup_one H_subgroup;
Save Eq_quotGr_refl;

Goal symmetric Eq_quotGr;
  Intros;
  Refine extenPred; Refine (G.InvGr.ap (G.DivGr.ap2 x y));
  Refine +1 subgroup_inv H_subgroup H1;
  Refine Eq_trans (G.DivGr.ap2 (G.InvGr.ap (G.InvGr.ap y)) x);
    Refine Eq_sym; Refine TimesInvGr_distrib;
  Refine exten2 ?? ?.Eq_refl; Refine InvGr_invol;
Save Eq_quotGr_sym;

Goal transitive Eq_quotGr;
  Intros;
  Refine extenPred; Refine G.TimesGr.ap2 (G.DivGr.ap2 x y) (G.DivGr.ap2 y z);
    Refine +1 subgroup_times H_subgroup H1 H2;
  Refine Eq_trans (G.TimesGr.ap2 x (G.TimesGr.ap2 (G.InvGr.ap y) (G.DivGr.ap2 y z)));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (G.DivGr.ap2 (G.TimesGr.ap2 (G.InvGr.ap y) y) z);
    Refine TimesGr_assoc;
  Refine Eq_trans (G.DivGr.ap2 G.OneGr z);
    Refine exten2 ?? ?.Eq_refl; Refine lInvGr_invers;
  Refine lOneGr_ident;
Save Eq_quotGr_trans;

[QuotientSet = Set_intro Eq_quotGr_refl Eq_quotGr_sym Eq_quotGr_trans];

(* --------------------------------------------------------------------------------
   Show that InvGr and TimesGr remain functions with respect to the equality on G/H.
*)

Goal extensional (G.InvGr.ap : op QuotientSet.el);
  Intros;
  i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2;
  Refine extenPred;
    Refine i (p (i x') x);
    Refine Eq_sym; Refine TimesInvGr_distrib;
  Refine subgroup_inv H_subgroup;
  Refine extenPred;
    Refine m (p (i x') (m x x')) (i x');
    Refine +1 normalSubgroup_ax H_normalSubgroup H1;
  Refine Eq_trans (p (p (i x') (m x x')) x');
    Refine exten2 G.TimesGr ?.Eq_refl; Refine InvGr_invol;
  Refine Eq_trans (p (m (p (i x') x) x') x');
    Refine exten2 ???.Eq_refl; Refine TimesGr_assoc;
  Refine Eq_trans (p (p (i x') x) (p (i x') x'));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (p (p (i x') x) G.OneGr);
    Refine exten2 ??.Eq_refl; Refine lInvGr_invers;
  Refine rOneGr_ident;
Save invQGr_exten;

Goal extensional2 (G.TimesGr.ap2 : bop QuotientSet.el);
  Intros;
  i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2;
  Refine extenPred;
    Refine p (m (p x (m y y')) x) (m x x');
    Refine +1 subgroup_times H_subgroup ? H1;
    Refine +1 normalSubgroup_ax H_normalSubgroup H2;
  Refine Eq_trans (p (p x (m y y')) (p (i x) (m x x')));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (m (p x (m y y')) x');
    Refine exten2 ??.Eq_refl;
    Refine Eq_trans (m (p (i x) x) x');
      Refine TimesGr_assoc;
    Refine Eq_trans (m G.OneGr x');
      Refine exten2 ???.Eq_refl; Refine lInvGr_invers;
    Refine lOneGr_ident;
  Refine Eq_trans (m (m (p x y) y') x');
    Refine exten2 ???.Eq_refl; Refine TimesGr_assoc;
  Refine Eq_trans (p (p x y) (m (i y') x'));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine exten2 ??.Eq_refl; Refine TimesInvGr_distrib;
Save timesQGr_exten;

[     OneQGr : el QuotientSet
          = G.OneGr
]
[     InvQGr : Fun QuotientSet QuotientSet
          = Fun_intro (G.InvGr.ap : op QuotientSet.el) invQGr_exten
]
[     TimesQGr : Fun2 QuotientSet QuotientSet QuotientSet
          = Fun2_intro (G.TimesGr.ap2 : bop QuotientSet.el) timesQGr_exten
];

(* --------------------------------------------------------------------------------
   Show that OneQGr, InvQGr and TimesQGr satisfy the group axioms.
*)

Goal Associative TimesQGr;
  Intros a b c;
  i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2;
  Equiv H.ap (p (p a (p b c)) (i (p (p a b) c)));
  Refine extenPred; Refine m (p a (m (p b (p c (i c))) b)) a;
    Refine +1 normalSubgroup_ax H_normalSubgroup;
    Refine +1 normalSubgroup_ax H_normalSubgroup;
    Refine +1 Eq_quotGr_refl;
  Refine Eq_trans (p (p a (p b c)) (m (p (i c) (i b)) a));
    Refine Eq_trans (m (p (p a (p b c)) (p (i c) (i b))) a);
      Refine +1 Eq_sym; Refine +1 TimesGr_assoc;
    Refine exten2 ???.Eq_refl;
    Refine Eq_trans (p a (p (p b c) (p (i c) (i b))));
      Refine +1 TimesGr_assoc;
    Refine exten2 ??.Eq_refl;
    Refine Eq_trans (m (m (p b c) c) b);
      Refine +1 Eq_sym; Refine +1 TimesGr_assoc;
    Refine exten2 ???.Eq_refl; Refine TimesGr_assoc;
  Refine exten2 ??.Eq_refl;
  Refine Eq_trans (p (i c) (p (i b) (i a)));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (m (i c) (p a b));
    Refine exten2 ??.Eq_refl;
    Refine TimesInvGr_distrib;
  Refine TimesInvGr_distrib;
Save TimesQGr_assoc;

Goal rInverse TimesQGr OneQGr InvQGr;
  e == G.OneGr; i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2;
  Intros a;
  Equiv H.ap (m (m a a) e);
  Refine extenPred; Refine m a a;
    Refine +1 Eq_quotGr_refl;
  Refine Eq_trans (p (m a a) e);
    Refine Eq_sym; Refine rOneGr_ident;
  Refine exten2 ??.Eq_refl;
  Refine Eq_trans (m e e);
    Refine Eq_sym; Refine rInvGr_invers;
  Refine lOneGr_ident;
Save rInvQGr_invers;

Goal rIdentity TimesQGr OneQGr;
  e == G.OneGr; i == G.InvGr.ap; p == G.TimesGr.ap2; m == G.DivGr.ap2;
  Intros a;
  Equiv H.ap (m (p a e) a);
  Refine extenPred; Refine m a a;
  Refine exten2 ??.Eq_sym ?.Eq_refl; Refine rOneGr_ident;
  Refine Eq_quotGr_refl;
Save rOneQGr_ident;

Goal QuotientGroup : Group;
  Refine Group_intro;
  Refine +1 TimesQGr;
  Refine InvQGr;
  Refine OneQGr;
  Refine TimesQGr_assoc;
  Refine rInvQGr_invers;
  Refine rOneQGr_ident;
Save;

(* --------------------------------------------------------------------------------
   Suppose h is a homomorphism from G to G' such that h(H) = 0.
*)

[h : Homomorphism G G'];
[z : Eq (Image h.Homo_f H) (singleton G'.OneGr)];

(* Then f is a homomorpism from G/H to G'. *)

Goal Fun QuotientSet G'.car;
  Refine Fun_intro;
  Refine h.Homo_f.ap;
  Intros ___;
  Refine fst (kernelGr_lemma h x x');
  Refine fst (z ?); Refine ExIntro; Refine G.DivGr.ap2 x x';
  Refine pair ? ?.Eq_refl;
  Refine H1;
Save QHomoGr_f;

Goal Homomorphism QuotientGroup G';
  Refine HomomorphismGr_intro;
  Refine QHomoGr_f;
  intros; Refine HomoGr_times;
Save QHomoGr;

(* If this f is onto, and if kernel(f)=H, then f is a bijection. *)

Goal (Surjection QHomoGr_f) ->
     ({x|obj G} (QHomoGr.kernelGr.ap x) -> (H.ap x)) ->
     (Bijection QHomoGr_f);
  intros surj H;
  Refine pair ? surj;
  Intros a b _;
  Equiv H.ap (G.DivGr.ap2 a b);
  Refine H1;
  Refine snd (kernelGr_lemma h a b);
  Refine H2;
Save QHomoGr_bij;

Discharge h;

Discharge H;

(* ================================================================================
   Normal subgroups.
*)

Goal timesSGr : bop (Subset G.car);
  Intros H K;
  Refine Pred_intro;
  Refine [x:obj G] Ex2 [h,k:obj G] and3 (H.ap h) (K.ap k) (Eq x (G.TimesGr.ap2 h k));
  Intros x y __;
  Refine H2; Intros h k _;
  Refine Ex2Intro; Refine h; Refine k;
  Refine pair3 H3.and3_out1 H3.and3_out2;
  Refine Eq_trans x H1.Eq_sym;
  Refine and3_out3 H3;
Save;

[H,K | Subset G.car] [H_subgr : subgroup H] [K_normalSubgr : normalSubgroup K];

$[K_subgr : subgroup K = normalSubgroup_subgroup K_normalSubgr];

Goal (timesSGr H K).ap G.OneGr;
  Refine Ex2Intro; Refine G.OneGr; Refine G.OneGr;
  Refine pair3 (subgroup_one H_subgr) (subgroup_one K_subgr);

  Refine Eq_sym; Refine rOneGr_ident;
Save timesSGr_one;

Goal {x|obj G} ((timesSGr H K).ap x) -> (timesSGr H K).ap (G.InvGr.ap x);
  intros;
  Refine H1; intros h k _;
  Refine Ex2Intro; Refine G.InvGr.ap h; Refine G.DivGr.ap2 (G.DivGr.ap2 h k) h;
  Refine pair3 (subgroup_inv H_subgr H2.and3_out1);
  Refine normalSubgroup_ax K_normalSubgr; Refine (subgroup_inv K_subgr H2.and3_out2);

  Refine Eq_trans (G.InvGr.ap (G.TimesGr.ap2 h k));
    Refine exten; Refine and3_out3 H2;
  Refine Eq_trans (G.DivGr.ap2 (G.InvGr.ap k) h);
    Refine Eq_sym; Refine TimesInvGr_distrib;
  Refine Eq_sym;
  Refine Eq_trans (G.TimesGr.ap2 (G.InvGr.ap h) 
                                (G.TimesGr.ap2 h (G.DivGr.ap2 (G.InvGr.ap k) h)));
    Refine exten2 ??.Eq_refl ?.Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (G.TimesGr.ap2 (G.TimesGr.ap2 (G.InvGr.ap h) h)
                                (G.DivGr.ap2 (G.InvGr.ap k) h));
    Refine TimesGr_assoc;
  Refine Eq_trans (G.TimesGr.ap2 G.OneGr (G.DivGr.ap2 (G.InvGr.ap k) h));
    Refine exten2 ???.Eq_refl; Refine lInvGr_invers;
  Refine lOneGr_ident;
Save timesSGr_inv;

Goal {x|obj G} ((timesSGr H K).ap x) -> {y|obj G} ((timesSGr H K).ap y) ->
     (timesSGr H K).ap (G.TimesGr.ap2 x y);
  intros;
  Refine H1; Refine H2; intros b l _ a k _;
  p == G.TimesGr.ap2; m == G.DivGr.ap2; i == G.InvGr.ap;
  Refine Ex2Intro; Refine p a b; Refine p (m (p (i b) k) (i b)) l;
  Refine pair3 (subgroup_times H_subgr H4.and3_out1 H3.and3_out1);
  Refine subgroup_times K_subgr ? H3.and3_out2;
  Refine normalSubgroup_ax K_normalSubgr H4.and3_out2;

  Refine Eq_trans (p (p a k) (p b l));
    Refine exten2 ? H4.and3_out3 H3.and3_out3;
  Refine Eq_sym;
  Refine Eq_trans (p (p a b) (p (p (i b) k) (p b l)));
    Refine exten2 ??.Eq_refl;
    Refine Eq_trans (p (p (p (i b) k) b) l);
      Refine exten2 ???.Eq_refl; Refine exten2 G.TimesGr ?.Eq_refl; Refine InvGr_invol;
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (p (p (p a b) (p (i b) k)) (p b l));
    Refine TimesGr_assoc;
  Refine exten2 ???.Eq_refl;
  Refine Eq_trans (p (p (p a b) (i b)) k);
    Refine TimesGr_assoc;
  Refine exten2 ???.Eq_refl;
  Refine Eq_trans (p a (m b b));
    Refine Eq_sym; Refine TimesGr_assoc;
  Refine Eq_trans (p a G.OneGr);
    Refine exten2 ??.Eq_refl; Refine rInvGr_invers;
  Refine rOneGr_ident;
Save timesSGr_times;

Goal subgroup (timesSGr H K);
  Refine subgroup_intro;
  Refine timesSGr_one;
  Refine timesSGr_inv;
  Refine timesSGr_times;
Save timesSGr_subgroup;

Discharge H;

Discharge G;
