
Module Group_homo Import Group;

(* 
   This module introduces group homomorphisms.
*)

[G,G' | Group];

(* --------------------------------------------------------------------------------
   Given a function which respects the multiplication of the
   group. Show it is a group homomorphism.
*)

[f : Fun G.car G'.car]

[f_times : {x,y:obj G} Eq (f.ap (G.TimesGr.ap2 x y))
                          (G'.TimesGr.ap2 (f.ap x) (f.ap y))];

$[One    : obj G            = G.OneGr]
$[One'   : obj G'           = G'.OneGr]
$[Inv    : UFunMdl G        = G.InvGr]
$[Inv'   : UFunMdl G'       = G'.InvGr]
$[Times  : BFunMdl G        = G.TimesGr]
$[Times' : BFunMdl G'       = G'.TimesGr]
$[Div    : BFunMdl G        = G.DivGr]
$[Div'   : BFunMdl G'       = G'.DivGr];

Goal HomoGr_intro_one : Eq (f.ap G.OneGr) G'.OneGr;
  Refine Eq_trans (Times'.ap2 (f.ap One) One');
    Refine Eq_sym; Refine G'.rOneGr_ident;
  Refine Eq_trans (Times'.ap2 (f.ap One) (Div'.ap2 (f.ap One) (f.ap One)));
  Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine G'.rInvGr_invers;
  Refine Eq_trans (Div'.ap2 (Times'.ap2 (f.ap One) (f.ap One)) (f.ap One));
    Refine G'.TimesGr_assoc;
  Refine Eq_trans (Div'.ap2 (f.ap One) (f.ap One));
    Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (f.ap (Times.ap2 One One));
    Refine Eq_sym; Refine f_times;
  Refine exten; Refine G.rOneGr_ident;
  Refine G'.rInvGr_invers;
Save;

Goal HomoGr_intro_inv : {x:obj G} Eq (f.ap (G.InvGr.ap x)) (G'.InvGr.ap (f.ap x));
  intros;
  Refine Eq_trans (Times'.ap2 One' (f.ap (Inv.ap x)));
    Refine Eq_sym; Refine G'.lOneGr_ident;
  Refine Eq_trans (Times'.ap2 (Times'.ap2 (Inv'.ap (f.ap x)) (f.ap x))
                             (f.ap (Inv.ap x)));
    Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine G'.lInvGr_invers;
  Refine Eq_trans (Times'.ap2 (Inv'.ap (f.ap x))
                             (Times'.ap2 (f.ap x) (f.ap (Inv.ap x))));
    Refine Eq_sym; Refine G'.TimesGr_assoc;
  Refine Eq_trans (Times'.ap2 (Inv'.ap (f.ap x)) (f.ap One));
    Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (f.ap (Div.ap2 x x));
    Refine Eq_sym; Refine f_times;
    Refine exten; Refine G.rInvGr_invers;
  Refine Eq_trans (Times'.ap2 (Inv'.ap (f.ap x)) One');
    Refine exten2 ? ?.Eq_refl; Refine HomoGr_intro_one;
  Refine G'.rOneGr_ident;
Save;

Goal HomomorphismGr_intro : Homomorphism G G';
  Refine Homomorphism_intro f;
  Refine ThreeSET_elim [c:FuncSymb sigGr] homo_resp_Functions f c;
  Refine HomoGr_intro_one;
  Refine HomoGr_intro_inv;
  Refine f_times;
  Intros c; Refine EmptySET_iter c;
Save;

Discharge f;

(* --------------------------------------------------------------------------------
   Let h be a group homomorphism. Define extracting terms.
*)

[h : Homomorphism G G'];

  [     HomoGr_one
            : Eq (h.Homo_f.ap G.OneGr) G'.OneGr
            = h.Homo_resp_Functions star31
  ]
  [     HomoGr_inv
            : {x:obj G} Eq (h.Homo_f.ap (G.InvGr.ap x))
                           (G'.InvGr.ap (h.Homo_f.ap x))
            = h.Homo_resp_Functions star32
  ]
  [     HomoGr_times
            : {x,y:obj G} Eq (h.Homo_f.ap (G.TimesGr.ap2 x y))
                             (G'.TimesGr.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = h.Homo_resp_Functions star33
  ];

Freeze OneGr InvGr TimesGr;

(* --------------------------------------------------------------------------------
   Some additional lemma's.
*)

  [     HomoGr_MN
            : Homomorphism G.MonoidGr G'.MonoidGr
            = HomomorphismMN_intro|G.MonoidGr|G'.MonoidGr h.Homo_f
                                                          HomoGr_one HomoGr_times
  ];

  Goal HomoGr_not_one : (Injection h.Homo_f) ->
                         {x|obj G} ~(Eq x G.OneGr) -> ~(Eq (h.Homo_f.ap x) G'.OneGr);
    Refine HomoMN_not_one HomoGr_MN;
  Save;

  Goal {a,b:obj G} iff (Eq (h.Homo_f.ap a) (h.Homo_f.ap b))
                       (Eq (h.Homo_f.ap (G.DivGr.ap2 a b)) G'.OneGr);
    intros; f == h.Homo_f.ap;
    Refine pair;

    intros;
    Refine Eq_trans (G'.TimesGr.ap2 (f a) (f (G.InvGr.ap b)));
      Refine HomoGr_times;
    Refine Eq_trans (G'.DivGr.ap2 (f a) (f a));
      Refine +1 rInvGr_invers;
    Refine exten2 ??.Eq_refl;
    Refine Eq_trans (G'.InvGr.ap (f b));
      Refine HomoGr_inv;
    Refine exten ? H.Eq_sym;

    intros;
    Refine DivGr_lemma1;
    Refine Eq_trans (G'.TimesGr.ap2 (f a) (f (G.InvGr.ap b)));
      Refine exten2 G'.TimesGr ?.Eq_refl ?.Eq_sym; Refine HomoGr_inv;
    Refine Eq_trans (f (G.DivGr.ap2 a b));
      Refine Eq_sym; Refine HomoGr_times;
    Refine H;
  Save HomoGr_lemma1;

Discharge G;
  
Goal InvGr_homoGr : {G|Group} (Commutative G.TimesGr) -> G.Endomorphism;
  intros;
  Refine HomomorphismGr_intro;
  Refine G.InvGr;
  intros;
  Refine Eq_sym;
  Refine Eq_trans (G.TimesGr.ap2 (G.InvGr.ap y) (G.InvGr.ap x));
    Refine H;
  Refine TimesInvGr_distrib G;
Save;

Unfreeze OneGr InvGr TimesGr;

