 
Module Field Import Ring;

[     sigFd : Signature
          = Signature_intro (SixSET_iter ZeroN    (* a constant *)
                                         ZeroN    (* a constant *)
                                         OneN     (* a unary function *)
                                         OneN     (* a unary function *)
                                         TwoN     (* a binary function *)
                                         TwoN     (* a binary function *)
                            )
                            EmptySET_nat
];

Goal axiomsFd : Axioms sigFd;
  Refine Axioms_intro;
  Intros A IC IP;
  Zero  == (IC star61).apn : el A;
  One   == (IC star62).apn : el A;
  Neg   == IC star63       : Fun A A;
  Recip == IC star64       : Fun A A;
  Plus  == IC star65       : Fun2 A A A;
  Times == IC star66       : Fun2 A A A;
  Refine and9 (Associative Plus)
              (Commutative Plus)
              (Identity Plus Zero)
              (Inverse Plus Zero Neg)
              (Associative Times)
              (Commutative Times)
              (Identity Times One)
              (MultInverse Times Zero One Recip)
              (Distributive Plus Times);
Save;

[     Field
          = Model axiomsFd
];

Goal Field_intro : {A|Set}{Plus,Times|Fun2 A A A}{Neg,Recip|Fun A A}{Zero,One|el A}
      {Plus_assoc   : Associative Plus}    {Plus_commut  : Commutative Plus}
      {rZero_ident  : rIdentity Plus Zero} {rNeg_invers  : rInverse Plus Zero Neg}
      {Times_assoc  : Associative Times}   {Times_commut : Commutative Times}
      {rOne_ident   : rIdentity Times One}
      {Recip_invers : MultInverse Times Zero One Recip}
      {rPlus_Times_distrib : rDistributive Plus Times}
      Field;
  intros;
  Refine Model_intro;
  Refine A;
  Refine SixSET_elim [c:FuncSymb sigFd] nFunc A (FuncArity c);
  Refine constant Zero;
  Refine constant One;
  Refine Neg;
  Refine Recip;
  Refine Plus;
  Refine Times;
  intros p; Refine EmptySET_iter p;
  Refine pair9 Plus_assoc
               Plus_commut
               (Identity_intro Plus_commut rZero_ident)
               (Inverse_intro Plus_commut rNeg_invers)
               Times_assoc
               Times_commut
               (Identity_intro Times_commut rOne_ident)
               Recip_invers
               (Distributive_intro Times_commut rPlus_Times_distrib);
Save;

(* --------------------------------------------------------------------------------
   Let F be a field. Define functions to extract all components of F
   and everything we know from rings.
*)

[F : Field];

  [ZeroFd        : obj F                    = intCons F star61]
  [OneFd         : obj F                    = intCons F star62]
  [NegFd         : UFunMdl F                = intFunc F star63]
  [RecipFd       : UFunMdl F                = intFunc F star64]
  [PlusFd        : BFunMdl F                = intFunc F star65]
  [TimesFd       : BFunMdl F                = intFunc F star66];

  [PlusFd_assoc        : Associative PlusFd                       = and9_out1 F.axioms]
  [PlusFd_commut       : Commutative PlusFd                       = and9_out2 F.axioms]
  [ZeroFd_ident        : Identity PlusFd ZeroFd                   = and9_out3 F.axioms]
  [NegFd_invers        : Inverse PlusFd ZeroFd NegFd              = and9_out4 F.axioms]
  [TimesFd_assoc       : Associative TimesFd                      = and9_out5 F.axioms]
  [TimesFd_commut      : Commutative TimesFd                      = and9_out6 F.axioms]
  [OneFd_ident         : Identity TimesFd OneFd                   = and9_out7 F.axioms]
  [RecipFd_invers      : MultInverse TimesFd ZeroFd OneFd RecipFd = and9_out8 F.axioms]
  [TimesPlusFd_distrib : Distributive PlusFd TimesFd              = and9_out9 F.axioms];

Freeze ZeroFd OneFd NegFd RecipFd PlusFd TimesFd;

  [lZeroFd_ident        : lIdentity PlusFd ZeroFd      = fst ZeroFd_ident       ]
  [lNegFd_invers        : lInverse PlusFd ZeroFd NegFd = fst NegFd_invers       ]
  [lOneFd_ident         : lIdentity TimesFd OneFd      = fst OneFd_ident        ]
  [lTimesPlusFd_distrib : lDistributive PlusFd TimesFd = fst TimesPlusFd_distrib]
  [rZeroFd_ident        : rIdentity PlusFd ZeroFd      = snd ZeroFd_ident       ]
  [rNegFd_invers        : rInverse PlusFd ZeroFd NegFd = snd NegFd_invers       ]
  [rOneFd_ident         : rIdentity TimesFd OneFd      = snd OneFd_ident        ]
  [rTimesPlusFd_distrib : rDistributive PlusFd TimesFd = snd TimesPlusFd_distrib];

  [     RingFd : Ring
            = Ring_intro F.car PlusFd TimesFd NegFd ZeroFd OneFd
                         PlusFd_assoc PlusFd_commut rZeroFd_ident rNegFd_invers
                         TimesFd_assoc OneFd_ident TimesPlusFd_distrib
  ]
  [     GroupFd : Group
            = applGroup RingFd
  ]
  [     MonoidFd : Monoid
            = Monoid_intro TimesFd_assoc OneFd_ident
  ];

  [     MinusFd : BFunMdl F
            = RingFd.MinusRg
  ]

  [     NegOneFd : obj F
            = RingFd.NegOneRg
  ]
  [     TwoFd : obj F
            = RingFd.TwoRg
  ];

  [     TwoFd_lemma1 : {x:obj F} Eq (PlusFd.ap2 x x) (TimesFd.ap2 TwoFd x)
            = RingFd.TwoRg_lemma1
  ];

  [     DoubleFd : UFunMdl F
            = RingFd.DoubleRg
  ]
  [     SquareFd : UFunMdl F
            = RingFd.SquareRg
  ];

  [     TimesFd_lemma1
            : {a,b,c,d:obj F} Eq (TimesFd.ap2 (PlusFd.ap2 a b) (PlusFd.ap2 c d))
                                 (PlusFd.ap2 (PlusFd.ap2 (PlusFd.ap2 (TimesFd.ap2 a c)
                                                                     (TimesFd.ap2 a d))
                                                         (TimesFd.ap2 b c))
                                             (TimesFd.ap2 b d))
            = RingFd.TimesRg_lemma1
  ]
  [     TimesFd_lemma2
            : {x,y:obj F} Eq (SquareFd.ap (PlusFd.ap2 x y))
                             (PlusFd.ap2 (PlusFd.ap2 (SquareFd.ap x)
                                                     (DoubleFd.ap (TimesFd.ap2 x y)))
                                         (SquareFd.ap y))
            = RingFd.TimesRg_lemma2 TimesFd_commut
  ]
  [     TimesFd_lemma3
            : {x,y:obj F} Eq (SquareFd.ap (MinusFd.ap2 x y))
                             (PlusFd.ap2 (MinusFd.ap2 (SquareFd.ap x)
                                                      (DoubleFd.ap (TimesFd.ap2 x y)))
                                         (SquareFd.ap y))
            = RingFd.TimesRg_lemma3 TimesFd_commut
  ];

  [     SquareFd_lemma2
            : {x,y:obj F} Eq (SquareFd.ap (PlusFd.ap2 x y))
                             (PlusFd.ap2 (SquareFd.ap (MinusFd.ap2 x y))
                                         (DoubleFd.ap (DoubleFd.ap (TimesFd.ap2 x y))))
            = RingFd.SquareRg_lemma1 TimesFd_commut
  ]
  [     SquareDoubleFd : {x:obj F} Eq (SquareFd.ap (DoubleFd.ap x))
                                      (DoubleFd.ap (DoubleFd.ap (SquareFd.ap x)))
            = RingFd.SquareDoubleRg
  ];

  [     NegFd_invol : Involutive NegFd
            = RingFd.NegRg_invol
  ]
  [     NegFd_inj : Injection NegFd
            = GroupFd.InvGr_inj
  ]
  [     NegFd_zero : {x|obj F} (Eq (NegFd.ap x) ZeroFd) -> Eq x ZeroFd
            = GroupFd.InvGr_one
  ]
  [     NegFd_not_zero : {x|obj F} ~(Eq x ZeroFd) -> ~(Eq (NegFd.ap x) ZeroFd)
            = GroupFd.InvGr_not_one
  ];

  [     MinusFd_lemma1 : {x,y|obj F} (Eq (MinusFd.ap2 x y) ZeroFd) -> Eq x y
            = RingFd.MinusRg_lemma1
  ]
  [     PlusFd_cancel : Cancelation PlusFd
            = RingFd.PlusRg_cancel
  ]
  [     rPlusFd_cancel : rCancelation PlusFd
            = RingFd.rPlusRg_cancel
  ]
  [     lPlusFd_cancel : lCancelation PlusFd
            = RingFd.lPlusRg_cancel
  ]
  [     NegZeroFd : Eq (NegFd.ap ZeroFd) ZeroFd
            = RingFd.NegZeroRg
  ]
  [     NegZeroFd_ident : Identity PlusFd (NegFd.ap ZeroFd)
            = RingFd.NegZeroRg_ident
  ]
  [     rNegZeroFd_ident : rIdentity PlusFd (NegFd.ap ZeroFd)
            = RingFd.rNegZeroRg_ident
  ]
  [     lNegZeroFd_ident : lIdentity PlusFd (NegFd.ap ZeroFd)
            = RingFd.lNegZeroRg_ident
  ]
  [     NegFd_lemma1 : {x|obj F} (Eq x ZeroFd) -> Eq x (NegFd.ap x)
            = RingFd.NegRg_lemma1
  ]
  [     PlusNegFd_distrib : {x,y:obj F} Eq (PlusFd.ap2 (NegFd.ap x) (NegFd.ap y))
                                     (NegFd.ap (PlusFd.ap2 x y))
            = RingFd.PlusNegRg_distrib
  ];

  [     TimesMinusFd_distrib : Distributive MinusFd TimesFd
           = RingFd.TimesMinusRg_distrib
  ]
  [      rTimesMinusFd_distrib : rDistributive MinusFd TimesFd
           = RingFd.rTimesMinusRg_distrib
  ]
  [      lTimesMinusFd_distrib : lDistributive MinusFd TimesFd
           = RingFd.lTimesMinusRg_distrib
  ];

  [     rTimesZeroFd : {x:obj F} Eq (TimesFd.ap2 x ZeroFd) ZeroFd
            = RingFd.rTimesZeroRg
  ]
  [     lTimesZeroFd : {x:obj F} Eq (TimesFd.ap2 ZeroFd x) ZeroFd
            = RingFd.lTimesZeroRg
  ]
  [     rTimesNegFd_distrib : {x,y:obj F} Eq (TimesFd.ap2 x (NegFd.ap y))
                                             (NegFd.ap (TimesFd.ap2 x y))
            = RingFd.rTimesNegRg_distrib
  ]
  [     lTimesNegFd_distrib : {x,y:obj F} Eq (TimesFd.ap2 (NegFd.ap x) y)
                                             (NegFd.ap (TimesFd.ap2 x y))
            = RingFd.lTimesNegRg_distrib
  ]
  [     TimesNegFd_distrib : {x,y:obj F} Eq (TimesFd.ap2 (NegFd.ap x) (NegFd.ap y))
                                            (TimesFd.ap2 x y)
            = RingFd.TimesNegRg_distrib
  ];

  [     SquareNegFd_distrib : {x:obj F} Eq (SquareFd.ap (NegFd.ap x)) (SquareFd.ap x)
            = [x:obj F] TimesNegFd_distrib x x
  ];

  [     rPlusFd_commut : {x,y,z:obj F} Eq (PlusFd.ap2 (PlusFd.ap2 x y) z)
                                          (PlusFd.ap2 (PlusFd.ap2 x z) y)
            = RingFd.rPlusRg_commut
  ]
  [     lPlusFd_commut : {x,y,z:obj F} Eq (PlusFd.ap2 x (PlusFd.ap2 y z))
                                          (PlusFd.ap2 y (PlusFd.ap2 x z))
            = RingFd.lPlusRg_commut
  ]
  [     rTimesFd_commut : {x,y,z:obj F} Eq (TimesFd.ap2 (TimesFd.ap2 x y) z)
                                           (TimesFd.ap2 (TimesFd.ap2 x z) y)
            = MonoidFd.rTimesMN_commut TimesFd_commut
  ]
  [     lTimesFd_commut : {x,y,z:obj F} Eq (TimesFd.ap2 x (TimesFd.ap2 y z))
                                           (TimesFd.ap2 y (TimesFd.ap2 x z))
            = MonoidFd.lTimesMN_commut TimesFd_commut
  ];

  Goal {x,y:obj F} Eq (TimesFd.ap2 (PlusFd.ap2 x y) (MinusFd.ap2 x y))
                     (MinusFd.ap2 (SquareFd.ap x) (SquareFd.ap y));
    intros; [my = NegFd.ap y];
    Refine Eq_trans (PlusFd.ap2 (PlusFd.ap2 (PlusFd.ap2 (SquareFd.ap x)
           (TimesFd.ap2 x my)) (TimesFd.ap2 y x)) (TimesFd.ap2 y my));
      Refine TimesFd_lemma1;
    Refine Eq_trans (MinusFd.ap2 (PlusFd.ap2 (SquareFd.ap x) (PlusFd.ap2
           (TimesFd.ap2 x my) (TimesFd.ap2 y x))) (SquareFd.ap y));
      Refine exten2; Refine Eq_sym; Refine PlusFd_assoc; Refine rTimesNegFd_distrib;
    Refine Eq_trans (MinusFd.ap2 (PlusFd.ap2 (SquareFd.ap x) ZeroFd) (SquareFd.ap y));
      Refine exten2 PlusFd ? ?.Eq_refl; Refine exten2 PlusFd ?.Eq_refl;
      Refine Eq_trans (PlusFd.ap2 (NegFd.ap (TimesFd.ap2 x y)) (TimesFd.ap2 x y));
        Refine exten2; Refine rTimesNegFd_distrib; Refine TimesFd_commut;
      Refine lNegFd_invers;
    Refine exten2 PlusFd ? ?.Eq_refl; Refine rZeroFd_ident;
  Save SquareFd_lemma1;

  Goal BFunMdl F;
    Refine Fun2_intro;
    Refine [x,y:obj F] TimesFd.ap2 x (RecipFd.ap y);
    Intros; Refine exten2 ? H; Refine exten ? H1;
  Save DivFd;

  Goal {x|obj F} ~(Eq x ZeroFd) -> (Eq (TimesFd.ap2 x (RecipFd.ap x)) OneFd);
    Intros;
    Refine (RecipFd_invers x).fst; Refine H;
  Save rRecipFd_invers;

  Goal {x|obj F} ~(Eq x ZeroFd) -> (Eq (TimesFd.ap2 (RecipFd.ap x) x) OneFd);
    Intros;
    Refine Eq_trans (TimesFd.ap2 x (RecipFd.ap x));
      Refine TimesFd_commut;
    Refine rRecipFd_invers H;
  Save lRecipFd_invers;

  Goal ~(Eq ZeroFd OneFd);
    notI; Refine (RecipFd_invers ZeroFd).snd;
    Refine Eq_trans ZeroFd; Refine lTimesZeroFd; Refine H;
    Refine Eq_refl;
  Save Field_non_trivial;

  Goal ~(Eq OneFd ZeroFd);
    Intros _; Refine Field_non_trivial; Refine Eq_sym H;
  Save OneFd_not_zero;

  Goal Eq (RecipFd.ap OneFd) OneFd;
    Refine Eq_trans (DivFd.ap2 OneFd OneFd);
      Refine Eq_sym; Refine lOneFd_ident;
    Refine rRecipFd_invers;
    Refine OneFd_not_zero;
  Save RecipOneFd;

  Goal {x|obj F} ~(Eq x ZeroFd) -> ~(Eq (RecipFd.ap x) ZeroFd);
    Intros ___;
    Refine Field_non_trivial;
    Refine Eq_trans (TimesFd.ap2 x ZeroFd);
      Refine Eq_sym; Refine rTimesZeroFd;
    Refine Eq_trans (TimesFd.ap2 x (RecipFd.ap x));
      Refine exten2; Refine Eq_refl; Refine Eq_sym H1;
    Refine rRecipFd_invers H;
  Save RecipFd_not_zero;

  Goal {x|obj F} ~(Eq x ZeroFd) -> Eq (RecipFd.ap (RecipFd.ap x)) x;
    Intros;
    Refine Eq_trans (DivFd.ap2 OneFd (RecipFd.ap x));
      Refine Eq_sym; Refine lOneFd_ident;
    Refine Eq_trans (DivFd.ap2 (DivFd.ap2 x x) (RecipFd.ap x));
      Refine exten2; Refine Eq_sym; Refine rRecipFd_invers H; Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 x (DivFd.ap2 (RecipFd.ap x) (RecipFd.ap x)));
       Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 x OneFd);
      Refine exten2; Refine Eq_refl; Refine (rRecipFd_invers (RecipFd_not_zero H));
    Refine rOneFd_ident;
  Save RecipFd_invol;

  Goal RecipFd_inj : {x,x'|obj F} ~(Eq x ZeroFd) -> ~(Eq x' ZeroFd) ->
                                 (Eq (RecipFd.ap x) (RecipFd.ap x')) -> Eq x x';
    intros;
    Refine Eq_trans (RecipFd.ap (RecipFd.ap x));
      Refine Eq_sym; Refine RecipFd_invol H;
    Refine Eq_trans (RecipFd.ap (RecipFd.ap x'));
      Refine exten ? H2;
    Refine RecipFd_invol H1;
  Save;

  Goal {x,y|obj F} ~(Eq x ZeroFd) -> ~(Eq y ZeroFd) ->
                  ~(Eq (TimesFd.ap2 x y) ZeroFd);
    intros; Intros _;
    Refine Field_non_trivial;
    Refine Eq_trans (TimesFd.ap2 ZeroFd (DivFd.ap2 (RecipFd.ap y) x));
      Refine Eq_sym; Refine lTimesZeroFd;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 x y) (DivFd.ap2 (RecipFd.ap y) x));
      Refine exten2; Refine Eq_sym H2; Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 x (TimesFd.ap2 y (DivFd.ap2 (RecipFd.ap y) x)));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 x (RecipFd.ap x));
      Refine +1 rRecipFd_invers H;
    Refine exten2; Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 y (RecipFd.ap y)) (RecipFd.ap x));
      Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 OneFd (RecipFd.ap x));
      Refine exten2; Refine rRecipFd_invers H1; Refine Eq_refl;
    Refine lOneFd_ident;
  Save TimesFd_not_zero;

  Goal SquareFd_not_zero
     : {x|obj F} ~(Eq x ZeroFd) -> ~(Eq (SquareFd.ap x) ZeroFd);
    intros; Refine TimesFd_not_zero H H;
  Save;

(* --------------------------------------------------------------------------------
*)

  [     PowerFd : Fun2 F.car Nat F.car
            = RingFd.PowerRg
  ];

  [     PowerFd_zero : {x:obj F} Eq (PowerFd.ap2 x ZeroN) OneFd
            = RingFd.PowerRg_zero
  ]
  [     PowerFd_succ : {x:obj F}{n:el Nat}
                        Eq (PowerFd.ap2 x (Succ.ap n))
                           (TimesFd.ap2 (PowerFd.ap2 x n) x)
            =  RingFd.PowerRg_succ
  ]
  [     PowerFd_one : {x:obj F} Eq (PowerFd.ap2 x OneN) x
            = RingFd.PowerRg_one
  ]
  [     PowerFd_two : {x:obj F} Eq (PowerFd.ap2 x TwoN) (SquareFd.ap x)
            = RingFd.PowerRg_two
  ]
  [     PowerFd_plus
            : {x:obj F}{m,n:el Nat} Eq (PowerFd.ap2 x (PlusN.ap2 m n))
                                       (TimesFd.ap2 (PowerFd.ap2 x m)
                                                    (PowerFd.ap2 x n))
            = RingFd.PowerRg_plus
  ]
  [     PowerFd_times
            : {x:obj F}{m,n:el Nat} Eq (PowerFd.ap2 x (TimesN.ap2 m n))
                                       (PowerFd.ap2 (PowerFd.ap2 x m) n)
            = RingFd.PowerRg_times
  ]
  [     PowerFd_distrib
            : {x,y:obj F}{n:el Nat} Eq (PowerFd.ap2 (TimesFd.ap2 x y) n)
                                       (TimesFd.ap2 (PowerFd.ap2 x n) (PowerFd.ap2 y n))
            = RingFd.PowerRg_distrib TimesFd_commut
  ]
  [     PowerFd_lemma1 : {n:el Nat} Eq (PowerFd.ap2 OneFd n) OneFd
            = RingFd.PowerRg_lemma1
  ]
  [     PowerFd_lemma2
            : {x:obj F}{m,n:el Nat} Eq (PowerFd.ap2 (PowerFd.ap2 x m) n)
                                       (PowerFd.ap2 (PowerFd.ap2 x n) m)
            = RingFd.PowerRg_lemma2
  ]
  [     PowerFd_lemma3
            : {n|el Nat} ~(Eq n ZeroN) -> Eq (PowerFd.ap2 ZeroFd n) ZeroFd
            = RingFd.PowerRg_lemma3
  ];

  Goal {x|obj F} ~(Eq x ZeroFd) -> {n:el Nat} ~(Eq (PowerFd.ap2 x n) ZeroFd);
    intros __;
    Refine nat_ind [n:el Nat] ~(Eq (PowerFd.ap2 x n) ZeroFd);
    Intros _; Refine OneFd_not_zero;
      Refine Eq_trans ? ?.Eq_sym H1;
      Refine PowerFd_zero;
    Intros n ih _;
    Refine TimesFd_not_zero ih H;
    Refine Eq_trans ? ?.Eq_sym H1;
    Refine PowerFd_succ;
  Save PowerFd_not_zero;

  Goal {x,y|obj F}{n|el Nat} ~(Eq y ZeroFd) ->
        Eq (DivFd.ap2 (PowerFd.ap2 x n) (PowerFd.ap2 y n))
           (PowerFd.ap2 (DivFd.ap2 x y) n);
    intros;
    Refine Eq_trans (DivFd.ap2 (PowerFd.ap2 (TimesFd.ap2 (DivFd.ap2 x y) y) n)
                               (PowerFd.ap2 y n));
      Refine exten2 ? ? ?.Eq_refl; Refine exten2 ? ? ?.Eq_refl;
      Refine Eq_trans (TimesFd.ap2 x OneFd);
        Refine Eq_sym; Refine rOneFd_ident;
      Refine Eq_trans (TimesFd.ap2 x (TimesFd.ap2 (RecipFd.ap y) y));
        Refine exten2 ? ?.Eq_refl ?.Eq_sym; Refine lRecipFd_invers H;
      Refine TimesFd_assoc;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 (PowerFd.ap2 (DivFd.ap2 x y) n)
                                               (PowerFd.ap2 y n)) (PowerFd.ap2 y n));
      Refine exten2 ? ? ?.Eq_refl; Refine PowerFd_distrib;
    Refine Eq_trans (TimesFd.ap2 (PowerFd.ap2 (DivFd.ap2 x y) n)
                                 (DivFd.ap2 (PowerFd.ap2 y n) (PowerFd.ap2 y n)));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 (PowerFd.ap2 (DivFd.ap2 x y) n) OneFd);
      Refine exten2 ? ?.Eq_refl; Refine rRecipFd_invers; Refine PowerFd_not_zero H;
    Refine rOneFd_ident;
  Save PowerFd_div;

(* --------------------------------------------------------------------------------
   Assume the carrier being discrete, and we are able to dervive a few
   more consequences.
*)

  [F_discr : Discrete F.car];

  Goal {x,y:obj F} (Eq (TimesFd.ap2 x y) ZeroFd) -> ((Eq x ZeroFd) \/ (Eq y ZeroFd));
    intros;
    orE F_discr x ZeroFd; Refine inl; intros;
    orE F_discr y ZeroFd; Refine inr; intros;
    Refine TimesFd_not_zero H1 H2 H;
  Save TimesFd_zero;

(* If we had a square root function, then we could prove the next
   lemma constructively.
*)

  Goal {x|obj F} (Eq (SquareFd.ap x) ZeroFd) -> Eq x ZeroFd;
    intros;
    orE TimesFd_zero x x H; Refine Id; Refine Id;
  Save SquareFd_zero;

  Discharge F_discr;

(* --------------------------------------------------------------------------------
*)

  Goal {x,y|obj F} ~(Eq x ZeroFd) -> ~(Eq y ZeroFd) ->
                  Eq (TimesFd.ap2 (RecipFd.ap x) (RecipFd.ap y))
                     (RecipFd.ap (TimesFd.ap2 x y));
    Intros;
    [D = TimesFd_not_zero H1 H];
    Refine Eq_trans (TimesFd.ap2 (DivFd.ap2 (RecipFd.ap x) y) OneFd);
      Refine Eq_sym; Refine rOneFd_ident;
    Refine Eq_trans (RecipFd.ap (TimesFd.ap2 y x));
      Refine +1 exten; Refine +1 TimesFd_commut;
    Refine Eq_trans (TimesFd.ap2 (DivFd.ap2 (RecipFd.ap x ) y)
                    (DivFd.ap2 (TimesFd.ap2 y x) (TimesFd.ap2 y x)));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rRecipFd_invers D;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 (DivFd.ap2 (RecipFd.ap x ) y)
                                             (TimesFd.ap2 y x)) (TimesFd.ap2 y x));
      Refine TimesFd_assoc;
    Refine Eq_trans (DivFd.ap2 OneFd (TimesFd.ap2 y x));
      Refine +1 lOneFd_ident;
    Refine exten2; Refine +1 Eq_refl;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 (DivFd.ap2 (RecipFd.ap x) y) y) x);
      Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 (RecipFd.ap x)
                                              (TimesFd.ap2 (RecipFd.ap y) y)) x);
      Refine exten2; Refine Eq_sym; Refine TimesFd_assoc; Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 (RecipFd.ap x) OneFd) x);
      Refine exten2; Refine exten2; Refine Eq_refl; Refine lRecipFd_invers H1;
                     Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 (RecipFd.ap x) x);
      Refine exten2; Refine rOneFd_ident; Refine Eq_refl;
    Refine lRecipFd_invers H;
  Save TimesRecipFd_distrib;

  Goal {x,y,a|obj F} ~(Eq y ZeroFd) -> ~(Eq a ZeroFd) ->
       Eq (DivFd.ap2 x y) (DivFd.ap2 (TimesFd.ap2 a x) (TimesFd.ap2 a y));
    intros;
    Refine Eq_trans (TimesFd.ap2 OneFd (DivFd.ap2 x y));
      Refine Eq_sym; Refine lOneFd_ident;
    Refine Eq_trans (TimesFd.ap2 (DivFd.ap2 a a) (DivFd.ap2 x y));
      Refine exten2 ? ?.Eq_sym ?.Eq_refl; Refine rRecipFd_invers H1;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 a (DivFd.ap2 x y)) a);
      Refine rTimesFd_commut;
    Refine Eq_trans (DivFd.ap2 (DivFd.ap2 (TimesFd.ap2 a x) y) a);
      Refine exten2 ? ? ?.Eq_refl; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 a x) (DivFd.ap2 (RecipFd.ap y) a));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (DivFd.ap2 (RecipFd.ap a) y);
      Refine TimesFd_commut;
    Refine TimesRecipFd_distrib H1 H;
  Save DivFd_lemma3;

  Goal {a,b,c|obj F} ~(Eq b ZeroFd) -> (Eq (TimesFd.ap2 a b) c) -> Eq a (DivFd.ap2 c b);
    intros;
    Refine Eq_trans (TimesFd.ap2 a OneFd);
      Refine Eq_sym; Refine rOneFd_ident;
    Refine Eq_trans (TimesFd.ap2 a (DivFd.ap2 b b));
      Refine exten2 ? ?.Eq_refl ?.Eq_sym; Refine rRecipFd_invers H;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 a b) b);
      Refine TimesFd_assoc;
    Refine exten2 ? H1 ?.Eq_refl;
  Save DivFd_lemma4;

  Goal {a,b,c|obj F} ~(Eq a ZeroFd) ->
                   (Eq (TimesFd.ap2 a b) c) -> Eq b (TimesFd.ap2 (RecipFd.ap a) c);
    intros;
    Refine Eq_trans (DivFd.ap2 c a);
      Refine +1 TimesFd_commut;
    Refine DivFd_lemma4 H;
    Refine Eq_trans (TimesFd.ap2 a b);
      Refine TimesFd_commut;
    Refine H1;
  Save DivFd_lemma5;

  Goal {a,b,c,d|obj F} ~(Eq b ZeroFd) -> ~(Eq c ZeroFd) ->
       (Eq (TimesFd.ap2 a b) (TimesFd.ap2 c d)) ->
       Eq (TimesFd.ap2 (RecipFd.ap c) a) (DivFd.ap2 d b);
    intros;
    Refine Eq_sym; Refine DivFd_lemma5 H1;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 c d) (RecipFd.ap b));
      Refine TimesFd_assoc;
    Refine Eq_sym; Refine DivFd_lemma4 H H2;
  Save DivFd_lemma6;

  Goal {a,b,c,d|obj F} ~(Eq b ZeroFd) -> ~(Eq c ZeroFd) ->
       (Eq (TimesFd.ap2 a b) (TimesFd.ap2 c d)) -> Eq (DivFd.ap2 a c) (DivFd.ap2 d b);
    intros;
    Refine Eq_trans (TimesFd.ap2 (RecipFd.ap c) a);
      Refine TimesFd_commut;
    Refine DivFd_lemma6 H H1 H2;
  Save DivFd_lemma7;

  Goal SquareTimesFd : {x,y:obj F} Eq (SquareFd.ap (TimesFd.ap2 x y))
                                     (TimesFd.ap2 (SquareFd.ap x) (SquareFd.ap y));
    intros;
    Refine Eq_trans (TimesFd.ap2 x (TimesFd.ap2 y (TimesFd.ap2 x y)));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 x (TimesFd.ap2 x (SquareFd.ap y)));
      Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 x y) y);
      Refine TimesFd_commut; Refine Eq_sym; Refine TimesFd_assoc;
    Refine TimesFd_assoc;
  Save;

  Goal {a|obj F} ~(Eq a ZeroFd) ->
       {x,y|obj F} (Eq (TimesFd.ap2 x a) (TimesFd.ap2 y a)) -> (Eq x y);
    Intros;
    Refine Eq_trans (TimesFd.ap2 x OneFd);
      Refine Eq_sym; Refine rOneFd_ident;
    Refine Eq_trans (TimesFd.ap2 x (DivFd.ap2 a a));
      Refine exten2; Refine Eq_refl; Refine Eq_sym; Refine rRecipFd_invers H;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 x a) a);
      Refine TimesFd_assoc;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 y a) a);
      Refine exten2; Refine H1; Refine Eq_refl;
    Refine Eq_trans (TimesFd.ap2 y (DivFd.ap2 a a));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 y OneFd);
      Refine exten2; Refine Eq_refl; Refine rRecipFd_invers H;
    Refine rOneFd_ident;
  Save rTimesFd_cancel;

  Goal {a|obj F} ~(Eq a ZeroFd) ->
       {x,y|obj F} (Eq (TimesFd.ap2 a x) (TimesFd.ap2 a y)) -> (Eq x y);
    Intros;
    Refine rTimesFd_cancel H;
    Refine Eq_trans (TimesFd.ap2 a x); Refine TimesFd_commut;
    Refine Eq_trans (TimesFd.ap2 a y); Refine +1 TimesFd_commut;
    Refine H1;
  Save lTimesFd_cancel;

  Goal RecipNegFd_distrib
     : {x|obj F} ~(Eq x ZeroFd) ->
       Eq (RecipFd.ap (NegFd.ap x)) (NegFd.ap (RecipFd.ap x));
    intros;
    Refine Eq_trans (TimesFd.ap2 (RecipFd.ap (NegFd.ap x)) OneFd);
      Refine Eq_sym; Refine rOneFd_ident;
    Refine Eq_trans (TimesFd.ap2 (RecipFd.ap (NegFd.ap x))
                                 (TimesFd.ap2 (NegFd.ap x) (NegFd.ap (RecipFd.ap x))));
      Refine exten2 TimesFd ?.Eq_refl;
      Refine Eq_trans (TimesFd.ap2 x (RecipFd.ap x));
        Refine Eq_sym; Refine rRecipFd_invers H;
      Refine Eq_sym; Refine TimesNegFd_distrib;
    Refine Eq_trans (TimesFd.ap2 (TimesFd.ap2 (RecipFd.ap (NegFd.ap x)) (NegFd.ap x))
                                 (NegFd.ap (RecipFd.ap x)));
      Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 OneFd (NegFd.ap (RecipFd.ap x)));
      Refine exten2 TimesFd ? ?.Eq_refl;
      Refine lRecipFd_invers; Refine NegFd_not_zero H;
    Refine lOneFd_ident;
  Save;

  Goal {x,y|obj F} ~(Eq y ZeroFd) -> Eq (DivFd.ap2 (TimesFd.ap2 x y) y) x;
    intros;
    Refine Eq_trans (TimesFd.ap2 x (DivFd.ap2 y y));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (TimesFd.ap2 x OneFd);
      Refine exten2 ? ?.Eq_refl; Refine rRecipFd_invers H;
    Refine rOneFd_ident;
  Save DivFd_lemma1;

  Goal {x,y|obj F} ~(Eq x ZeroFd) -> Eq (DivFd.ap2 (TimesFd.ap2 x y) x) y;
    intros;
    Refine Eq_trans (DivFd.ap2 (TimesFd.ap2 y x) x);
      Refine exten2 ? ? ?.Eq_refl; Refine TimesFd_commut;
    Refine DivFd_lemma1 H;
  Save DivFd_lemma2;

Discharge F;

(* ================================================================================
   Define field homomorphism.
*)

[F,F' | Field];

  Goal HomomorphismFd_intro
     : {f:Fun F.car F'.car}
       {f_one   : Eq (f.ap F.OneFd) F'.OneFd}
       {f_plus  : {x,y:obj F} Eq (f.ap (F.PlusFd.ap2 x y))
                                 (F'.PlusFd.ap2 (f.ap x) (f.ap y))}
       {f_times : {x,y:obj F} Eq (f.ap (F.TimesFd.ap2 x y))
                                 (F'.TimesFd.ap2 (f.ap x) (f.ap y))}
       Homomorphism F.RingFd F'.RingFd;
    intros;
    Refine HomomorphismRg_intro;
    Refine f;
    Refine f_one;
    Refine f_plus;
    Refine f_times;
  Save;

  [h : Homomorphism F.RingFd F'.RingFd];

  [     HomoFd_zero
            : Eq (h.Homo_f.ap F.ZeroFd) F'.ZeroFd
            = HomoRg_zero h
  ]
  [     HomoFd_one
            : Eq (h.Homo_f.ap F.OneFd) F'.OneFd
            = HomoRg_one h
  ]
  [     HomoFd_neg
            : {x:obj F} Eq (h.Homo_f.ap (F.NegFd.ap x)) (F'.NegFd.ap (h.Homo_f.ap x))
            = HomoRg_neg h
  ]
  [     HomoFd_plus
            : {x,y:obj F} Eq (h.Homo_f.ap (F.PlusFd.ap2 x y))
                             (F'.PlusFd.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = HomoRg_plus h
  ]
  [     HomoFd_times
            : {x,y:obj F} Eq (h.Homo_f.ap (F.TimesFd.ap2 x y))
                             (F'.TimesFd.ap2 (h.Homo_f.ap x) (h.Homo_f.ap y))
            = HomoRg_times h
  ]
  [     HomoFd_power
            : {x:obj F}{n:el Nat} Eq (h.Homo_f.ap (F.PowerFd.ap2 x n))
                                     (F'.PowerFd.ap2 (h.Homo_f.ap x) n)
            = HomoRg_power h
  ]
  [     pHomoFd_Gr : Homomorphism F.GroupFd F'.GroupFd
            = HomoRg_Gr h
  ];

  Goal {x|obj F}  ~(Eq x F.ZeroFd) -> ~(Eq (h.Homo_f.ap x) F'.ZeroFd);
    $[f       : Fun F.car F'.car = h.Homo_f  ]
    $[Recip   : UFunMdl F        = F.RecipFd ]
    $[Times'  : BFunMdl F'       = F'.TimesFd];
    Intros ___;
    Refine F'.Field_non_trivial;
    Refine Eq_trans (Times'.ap2 F'.ZeroFd (f.ap (Recip.ap x)));
      Refine Eq_sym; Refine lTimesZeroFd;
    Refine Eq_trans (Times'.ap2 (f.ap x) (f.ap (Recip.ap x)));
      Refine exten2 Times' H1.Eq_sym ?.Eq_refl;
    Refine Eq_trans (f.ap (F.DivFd.ap2 x x));
      Refine Eq_sym; Refine HomoFd_times;
    Refine Eq_trans (f.ap F.OneFd);
      Refine exten; Refine F.rRecipFd_invers H;
    Refine HomoFd_one;
  Save HomoFd_not_zero;

  Goal HomoFd_recip
     : {x|obj F} ~(Eq x F.ZeroFd) ->
                 Eq (h.Homo_f.ap (F.RecipFd.ap x)) (F'.RecipFd.ap (h.Homo_f.ap x));
    $[f       : Fun F.car F'.car = h.Homo_f]
    $[One'    : obj F'       = F'.OneFd]
    $[Recip   : UFunMdl F    = F.RecipFd]
    $[Recip'  : UFunMdl F'   = F'.RecipFd]
    $[Times'  : BFunMdl F'   = F'.TimesFd];
    intros;
    Refine Eq_trans (Times'.ap2 One' (f.ap (Recip.ap x)));
      Refine Eq_sym; Refine lOneFd_ident;
    Refine Eq_trans (Times'.ap2 (Times'.ap2 (Recip'.ap (f.ap x)) (f.ap x))
                                (f.ap (Recip.ap x)));
      Refine exten2 ? ? ?.Eq_refl; Refine Eq_sym; Refine lRecipFd_invers;
      Refine HomoFd_not_zero H;
    Refine Eq_trans (Times'.ap2 (Recip'.ap (f.ap x))
                                (Times'.ap2 (f.ap x) (f.ap (Recip.ap x))));
      Refine Eq_sym; Refine TimesFd_assoc;
    Refine Eq_trans (Times'.ap2 (Recip'.ap (f.ap x)) (f.ap F.OneFd));
      Refine exten2 ? ?.Eq_refl;
    Refine Eq_trans (f.ap (F.DivFd.ap2 x x));
      Refine Eq_sym; Refine HomoFd_times;
      Refine exten; Refine F.rRecipFd_invers H;
    Refine Eq_trans (Times'.ap2 (Recip'.ap (f.ap x)) One');
      Refine exten2 ? ?.Eq_refl; Refine HomoFd_one;
    Refine rOneFd_ident;
  Save;

Discharge F;

Unfreeze ZeroFd OneFd NegFd RecipFd PlusFd TimesFd;

