
Module Conjugate Import Complex AbsR;

(* 
   This module defines the conjugatie of a complex number:
      _
      x = re(x) - im(x) i
*)

[     conj : Cplx.el -> Cplx.el
          = [z:el Cplx] cart z.re (NegR.ap z.im)
];

Goal Conj : Fun Cplx Cplx;
  Refine Fun_intro;
  Refine conj;
  Intros ___; Refine eq_cplx_intro;
  Refine exten Re H;
  Refine exten NegR (exten Im H);
Save;

(* --------------------------------------------------------------------------------
   Show that the conjugate is a group endomorphism over the complex numbers.
*)

Goal Conj_plus : {x,y:el Cplx} Eq (Conj.ap (PlusC.ap2 x y))
                                  (PlusC.ap2 (Conj.ap x) (Conj.ap y));
  intros;
  Refine eq_cplx_intro; Refine Eq_refl;
  Refine Eq_sym; Refine PlusNegR_distrib;
Save;

Goal Conj_homoGr : Endomorphism COMPLEX_Group;
  Refine HomomorphismGr_intro;
  Refine Conj;
  Refine Conj_plus;
Save;

(* --------------------------------------------------------------------------------
   Show that the conjugate is a field endomorphism over the complex numbers.
*)

Goal Conj_one : Eq (Conj.ap OneC) OneC;
  Refine eq_cplx_intro; Refine Eq_refl; Refine NegZeroR;
Save;

Goal Conj_times : {x,y:el Cplx} Eq (Conj.ap (TimesC.ap2 x y))
                                   (TimesC.ap2 (Conj.ap x) (Conj.ap y));
  intros;
  Refine eq_cplx_intro;
  Refine exten2 ? ?.Eq_refl; Refine Eq_sym; Refine TimesNegR_distrib;
  Refine Eq_sym;
  Refine Eq_trans (PlusR.ap2 (NegR.ap (TimesR.ap2 x.re y.im))
                             (NegR.ap (TimesR.ap2 x.im y.re)));
    Refine exten2 PlusR; Refine rTimesNegR_distrib; Refine lTimesNegR_distrib;
  Refine PlusNegR_distrib;
Save;

Goal Conj_invol : Involutive Conj;
  Intros z; Refine eq_cplx_intro; Refine Eq_refl; Refine NegR_invol;
Save;

Goal Conj_homoRg : Homomorphism COMPLEX_Ring COMPLEX_Ring;
  Refine HomomorphismRg_intro;
  Refine Conj;
  Refine Conj_one;
  Refine Conj_plus;
  Refine Conj_times;
Save;

Goal Conj_homoFd : Homomorphism COMPLEX_Ring COMPLEX_Ring;
  Refine HomomorphismFd_intro;
  Refine Conj;
  Refine Conj_one;
  Refine Conj_plus;
  Refine Conj_times;
Save;

Goal Conj_endo : Endomorphism COMPLEX_Ring;
  Refine Conj_homoFd;
Save;

Goal Conj_auto : Automorphism COMPLEX_Ring;
  Intros #; Refine Conj_endo;
  Intros #; Refine Conj;
  Refine pair; Refine ?+1; Refine Conj_invol;
Save;

(* --------------------------------------------------------------------------------
   From that we may draw some conclusions.
*)

Goal Conj_zero : Eq (Conj.ap ZeroC) ZeroC;
  Refine Conj_homoFd.HomoFd_zero;
Save;

Goal Conj_neg : {x:el Cplx} Eq (Conj.ap (NegC.ap x)) (NegC.ap (Conj.ap x));
  Refine Conj_homoFd.HomoFd_neg;
Save;

Goal Conj_recip : {x|el Cplx} ~(Eq x ZeroC) ->
                              Eq (Conj.ap (RecipC.ap x)) (RecipC.ap (Conj.ap x));
  Refine Conj_homoFd.HomoFd_recip;
Save;

Goal {x|el Cplx} ~(Eq x ZeroC) -> ~(Eq (Conj.ap x) ZeroC);
  Refine HomoFd_not_zero Conj_homoFd;
Save Conj_not_zero;

(* ================================================================================
   Start proving some additional lemma's for wrt the conjugate.
*)

Goal Injection Conj;
  Intros ___;
  Refine eq_cplx_elim H; intros;
  Refine eq_cplx_intro; Refine H1; Refine NegR_inj H2;
Save Conj_inj;

(*  _
    i  = -i
*)

Goal Eq (Conj.ap I) (NegC.ap I);
  Refine eq_cplx_intro;
  Refine Eq_sym; Refine NegZeroR;
  Refine Eq_refl;
Save ConjI;

(*  _
    i != i
*)

Goal Conj_not_inverse : ~(Eq (Conj.ap I) I);
  Intros _;
  Refine Real_non_trivial;
  Refine Eq_sym; Refine OREAL.NegOFd_antisym;
  Refine Eq_sym; Refine snd H.eq_cplx_elim;
Save;

(*  _
    x = x   for real x
*)

Goal Conj_lemma1 : {x:el Real} Eq (Conj.ap (x.cp)) x.cp;
  intros;
  Refine eq_cplx_intro; Refine Eq_refl; Refine NegZeroR;
Save;

(*        _____       _     _
    (x y) (x y)  = (x x) (y y)
*)

Goal {x,y:el Cplx}
     Eq (TimesC.ap2 (TimesC.ap2 x y) (Conj.ap (TimesC.ap2 x y)))
        (TimesC.ap2 (TimesC.ap2 x (Conj.ap x)) (TimesC.ap2 y (Conj.ap y)));
  intros;
  [xy = TimesC.ap2 x y] [cxy = Conj.ap (TimesC.ap2 x y)]
  [xcx = TimesC.ap2 x (Conj.ap x)] [ycy = TimesC.ap2 y (Conj.ap y)]
  [cxcy = TimesC.ap2 (Conj.ap x) (Conj.ap y)];
  Refine Eq_trans (TimesC.ap2 xy cxcy);
    Refine exten2 ? ?.Eq_refl; Refine Conj_times;
  Refine Eq_trans (TimesC.ap2 x (TimesC.ap2 y cxcy));
    Refine Eq_sym; Refine TimesC_assoc;
  Refine Eq_trans (TimesC.ap2 x (TimesC.ap2 (Conj.ap x) ycy));
    Refine +1 TimesC_assoc;
  Refine exten2 ? ?.Eq_refl;
  Refine Eq_trans (TimesC.ap2 (TimesC.ap2 y (Conj.ap x)) (Conj.ap y));
    Refine TimesC_assoc;
  Refine Eq_trans (TimesC.ap2 (TimesC.ap2 (Conj.ap x) y) (Conj.ap y));
    Refine exten2 ? ? ?.Eq_refl; Refine TimesC_commut;
  Refine Eq_sym; Refine TimesC_assoc;
Save Conj_lemma4;

(*                         _
    (is real x)   ->   x = x
*)

Goal {x|el Cplx} (IsReal.ap x) -> Eq x (Conj.ap x);
  intros;
  Refine eq_cplx_intro; Refine Eq_refl; Refine NegR_lemma1 H;
Save IsRealConj;

(*      _
    x = x   ->    (is real x)
*)

Goal {x|el Cplx} (Eq x (Conj.ap x)) -> IsReal.ap x;
  intros;
  Refine NegR_antisym (snd H.eq_cplx_elim);
Save ConjIsReal;

(* ================================================================================
   Introduce a new function: the Euclidian scalar product.
*)

[     scProdC : Cplx.el -> Cplx.el -> Real.el
          = [x,y:el Cplx] PlusR.ap2 (TimesR.ap2 x.re y.re) (TimesR.ap2 x.im y.im)
];

Goal ScProdC : Fun2 Cplx Cplx Real;
  Refine Fun2_intro scProdC;
  Intros ______; andE eq_cplx_elim H; andE eq_cplx_elim H1;
  Refine exten2; Refine exten2 ? H2 H4; Refine exten2 ? H3 H5;
Save;

(* --------------------------------------------------------------------------------
   And prove some properies about these products.
*)

(*   _ _
    <x,y> = <x,y>
*)

Goal {x,y:el Cplx} Eq (ScProdC.ap2 (Conj.ap x) (Conj.ap y)) (ScProdC.ap2 x y);
  intros;
  Refine exten2 PlusR ?.Eq_refl;
  Refine TimesNegR_distrib;
Save ScProd_lemma1;

(*
    <-x,-y> = <x,y>
*)

Goal {x,y:el Cplx} Eq (ScProdC.ap2 (NegC.ap x) (NegC.ap y)) (ScProdC.ap2 x y);
  intros;
  Refine exten2 PlusR; Refine TimesNegR_distrib; Refine TimesNegR_distrib;
Save ScProdNegC;

(*
    <x,x> is a positve real
*)

Goal {x:el Cplx} PositiveR.ap (ScProdC.ap2 x x);
  intros;
  Refine PositivePlusR_compat;
  Refine PositiveSquareR; Refine PositiveSquareR;
Save ScProdC_pos;

(*       _
    re(x y) = <x,y>
*)

Goal Conj_lemma2 : {x,y:el Cplx} Eq (TimesC.ap2 x (Conj.ap y)).re (ScProdC.ap2 x y);
  intros;
  Refine exten2 PlusR ?.Eq_refl;
  Refine Eq_trans (NegR.ap (NegR.ap (TimesR.ap2 x.im y.im)));
    Refine exten; Refine rTimesNegR_distrib;
  Refine NegR_invol;
Save;

(*       _
    im(z z) = 0
*)

Goal Conj_lemma6 : {z:el Cplx} Eq (TimesC.ap2 z (Conj.ap z)).im ZeroR;
  intros;
  Refine Eq_trans (PlusR.ap2 (NegR.ap (TimesR.ap2 z.im z.re)) (TimesR.ap2 z.im z.re));
    Refine +1 lNegR_invers;
  Refine exten2 ? ? ?.Eq_refl;
  Refine Eq_trans (NegR.ap (TimesR.ap2 z.re z.im));
    Refine +1 exten; Refine +1 TimesR_commut;
  Refine REAL.rTimesNegFd_distrib;
Save;

(*    _
    z z  =  <z,z>
*)

Goal Conj_lemma3 : {z:el Cplx} Eq (TimesC.ap2 z (Conj.ap z)) (ScProdC.ap2 z z).cp;
  intros;
  Refine eq_cplx_intro; Refine Conj_lemma2; Refine Conj_lemma6;
Save;

(*
    <x,y> = <y,x>
*)

Goal ScProdC_commut : Commutative ScProdC;
  Intros;
  Refine exten2 PlusR; Refine TimesR_commut; Refine TimesR_commut;
Save;

(*       _
    re(x x) is positive
*)

Goal {x:el Cplx} PositiveR.ap (TimesC.ap2 x (Conj.ap x)).re;
  intros;
  Refine PositivePlusR_compat;
  Refine PositiveSquareR;
  Refine extenPred PositiveR; Refine NegR.ap (NegR.ap (SquareR.ap x.im));
    Refine exten NegR; Refine Eq_sym; Refine rTimesNegR_distrib;
  Refine extenPred PositiveR; Refine SquareR.ap x.im;
    Refine Eq_sym; Refine NegR_invol;
  Refine PositiveSquareR;
Save Conj_lemma5;

(*       2     2  2
    <x,x>  = <x ,x >
*)

Goal {x:el Cplx} Eq (SquareR.ap (ScProdC.ap2 x x))
                    (ScProdC.ap2 (SquareC.ap x) (SquareC.ap x));
  intros;
  [x1 = Re.ap x] [x2 = Im.ap x];
  [x12 = SquareR.ap x1] [x22 = SquareR.ap x2];
  Equiv Eq (SquareR.ap (PlusR.ap2 x12 x22))
           (PlusR.ap2 (SquareR.ap (SquareC.ap x).re) (SquareR.ap (SquareC.ap x).im));
  Refine Eq_trans (PlusR.ap2 (SquareR.ap (MinusR.ap2 x12 x22))
			     (DoubleR.ap (DoubleR.ap (TimesR.ap2 x12 x22))));
    Refine REAL.SquareFd_lemma2;
  Refine exten2;
  Refine exten; Refine Eq_sym (eq_cplx_elim ?.SquareC_elim).fst;
  Refine Eq_trans (DoubleR.ap (DoubleR.ap (SquareR.ap (TimesR.ap2 x1 x2))));
    Refine exten; Refine exten; Refine Eq_sym; Refine SquareTimesR;
  Refine Eq_trans (SquareR.ap (DoubleR.ap (TimesR.ap2 x1 x2)));
    Refine Eq_sym; Refine REAL.SquareDoubleFd;
  Refine exten; Refine Eq_sym (eq_cplx_elim ?.SquareC_elim).snd;
Save ScProdC_square;

