
Module AbsR Import SqrtR;

(* Define the absolute value of a real number. The following
   possibilities come in mind:

     |x| = Sqrt (x^2)
     |x| = max (x, -x)
     |x| = if (x<0) -x x

   We chose the first because it is close to the definition of
   absolute value for the complex numbers.
*)

(* --------------------------------------------------------------------------------
   Prove some properties of the absolute value.
*)

[     AbsR : Fun Real Real
          = Fun_intro ([x:el Real] SqrtR.ap (SquareR.ap x))
                      ([x,x'|el Real][H:Eq|Real x x'] exten SqrtR (exten SquareR H))
];

[     PositiveAbsR : {x:el Real} PositiveR.ap (AbsR.ap x)
          = [x:el Real] PositiveSqrtR (PositiveSquareR x)
]
[     AbsR_pos : {x|el Real} (PositiveR.ap x) -> Eq (AbsR.ap x) x
          = SqrtR_lemma2
]
[     AbsR_neg : {x|el Real} (NegativeR.ap x) -> Eq (AbsR.ap x) (NegR.ap x)
          = SqrtR_lemma3
]
[     AbsR_lemma1 : {x:el Real} (Eq (AbsR.ap x) x) \/ (Eq (AbsR.ap x) (NegR.ap x))
          = [x:el Real] NegOrPosR x
                        ([H:ap NegativeR x] inr H.AbsR_neg)
                        ([H:ap PositiveR x] inl H.AbsR_pos)
];

Goal {x:el Real} Eq (AbsR.ap (NegR.ap x)) (AbsR.ap x);
  intros;
  Refine exten SqrtR; Refine SquareNegR_distrib;
Save AbsNegR_distrib;

Goal {x:el Real} LessEqR.ap2 x (AbsR.ap x);
  intros;
  orE NegOrPosR x;
  intros;
    Refine extenRel ? ?.Eq_refl H.SqrtR_lemma3.Eq_sym;
    Refine LessEqR_lemma2 H;
  intros;
    Refine extenRel ? ?.Eq_refl ? ?.LessEqR_refl;
    Refine Eq_sym (AbsR_pos H);
Save AbsLessEqR_lemma1;

Goal {x:el Real} LessEqR.ap2 (NegR.ap x) (AbsR.ap x);
  intros;
  Refine LessEqR_trans (AbsR.ap (NegR.ap x));
    Refine AbsLessEqR_lemma1;
  Refine extenRel ? ?.Eq_refl ?.AbsNegR_distrib ?.LessEqR_refl;
Save AbsLessEqR_lemma2;

(* ================================================================================
   Next we define the sign of a real.

      sign(x)  = -1     if x < 0
      sign(x)  = +1     if x >= 0
*)

[     signR : op Real.el
          = [x:el Real] select x.StrNegOrPosR NegOneR OneR
];

(* --------------------------------------------------------------------------------
   And prove some properties.
*)

Goal signR_ok : {x|el Real} (StrNegR.ap x) -> (PositiveR.ap x) -> Eq NegOneR OneR;
  intros;
  Refine H.snd (PositiveR_antisym H1 H.fst);
Save;

Goal signR_neg : {x|el Real} (StrNegR.ap x) -> Eq (signR x) NegOneR;
  intros; Refine select_left; Refine signR_ok; Refine H;
Save;

Goal signR_pos : {x|el Real} (PositiveR.ap x) -> Eq (signR x) OneR;
  intros; Refine select_right; Refine signR_ok; Refine H;
Save;

Goal SignR : Fun Real Real;
  Refine Fun_intro signR;
  Intros; orE StrNegOrPosR x;
  intros;
    Refine Eq_trans NegOneR;
    Refine signR_neg H1;
    Refine Eq_sym; Refine signR_neg;
    Refine extenPred StrNegR H H1;
  intros;
    Refine Eq_trans OneR;
    Refine signR_pos H1;
    Refine Eq_sym; Refine signR_pos;
    Refine extenPred PositiveR H H1;
Save;

Goal SignR_neg : {x|el Real} (StrNegR.ap x) -> Eq (SignR.ap x) NegOneR;
  Refine signR_neg;
Save;

Goal SignR_pos : {x|el Real} (PositiveR.ap x) -> Eq (SignR.ap x) OneR;
  Refine signR_pos;
Save;

Goal SignR_One_NegOne
   : {x:el Real} (Eq (SignR.ap x) OneR) \/ (Eq (SignR.ap x) NegOneR);
  intros; orE StrNegOrPosR x;
  intros; Refine inr; Refine SignR_neg H;
  intros; Refine inl; Refine SignR_pos H;
Save;

Goal SignR_lemma1 : {x:el Real} Eq (SquareR.ap (SignR.ap x)) OneR;
  intros; orE SignR_One_NegOne x;
  intros;
    Refine Eq_trans (SquareR.ap OneR) (exten SquareR H);
    Refine lOneR_ident;
  intros;
    Refine Eq_trans (SquareR.ap NegOneR) (exten SquareR H);
    Refine Eq_trans (SquareR.ap OneR); Refine SquareNegR_distrib;
    Refine lOneR_ident;
Save;

Goal SignAbsR_lemma1 : {x:el Real} Eq (TimesR.ap2 (SignR.ap x) (AbsR.ap x)) x;
  intros; orE StrNegOrPosR x;
  intros;
    Refine Eq_trans (TimesR.ap2 NegOneR (NegR.ap x));
      Refine exten2; Refine SignR_neg H; Refine AbsR_neg H.fst;
    Refine Eq_trans (TimesR.ap2 OneR x);
      Refine TimesNegR_distrib;
    Refine lOneR_ident;
  intros;
    Refine Eq_trans (TimesR.ap2 OneR x);
      Refine exten2; Refine SignR_pos H; Refine AbsR_pos H;
    Refine lOneR_ident;
Save;

Goal {x|el Real} ~(Eq x ZeroR) -> Eq (SignR.ap (NegR.ap x)) (NegR.ap (SignR.ap x));
  intros; orE StrNegOrPosR x;

  intros;
  Refine Eq_trans OneR;
    Refine SignR_pos; Refine PositiveNegR_elim; Refine fst H1;
  Refine Eq_trans (NegR.ap (NegR.ap OneR));
    Refine Eq_sym; Refine NegR_invol;
  Refine exten; Refine Eq_sym; Refine SignR_neg H1;

  intros;
  Refine Eq_trans (NegR.ap OneR);
    Refine +1 exten NegR; Refine +1 Eq_sym; Refine +1 SignR_pos H1;
  Refine SignR_neg; Refine pair;
  Refine NegativeNegR_elim; Refine H1;
  Intros _; Refine H;
  Refine Eq_trans (NegR.ap (NegR.ap x));
    Refine Eq_sym; Refine NegR_invol;
  Refine Eq_trans (NegR.ap ZeroR);
    Refine exten ? H2;
  Refine NegZeroR;
Save SignNegR;

Goal {x:el Real} Eq (SignR.ap (DoubleR.ap x)) (SignR.ap x);
  intros; orE StrNegOrPosR x;

  intros;
  Refine Eq_trans NegOneR;
    Refine +1 Eq_sym; Refine +1 SignR_neg H;
  Refine SignR_neg;
  andE H; Refine pair;
  Refine extenPred PositiveR; Refine (DoubleR.ap (NegR.ap x)); Refine PlusNegR_distrib;
  Refine PositivePlusR_compat H1 H1;
  Refine DoubleR_not_zero H2;

  intros;
  Refine Eq_trans OneR;
    Refine +1 Eq_sym; Refine +1 SignR_pos H;
  Refine SignR_pos;
  Refine PositivePlusR_compat H H;
Save SignDoubleR;

Goal {x,y|el Real} (PositiveR.ap x) -> (PositiveR.ap y) ->
                   Eq (SignR.ap (TimesR.ap2 x y)) OneR;
  intros;
  Refine SignR_pos; Refine PositiveTimesR_compat H H1;
Save SignTimesR;
