;;;;;;;;;;;;;;;;;;;
;; maak de faces ;;
;;;;;;;;;;;;;;;;;;;

(make-face 'redface)
(make-face 'yelface)
(make-face 'greface)

(set-face-foreground 'redface "red")
(set-face-foreground 'yelface "yellow")
(set-face-foreground 'greface "green")

;;;;;;;;;;;;;;;;;;;
;; de muis-faces ;;
;;;;;;;;;;;;;;;;;;;

(copy-face 'redface 'redmouse)
(invert-face 'redmouse)
(copy-face 'yelface 'yelmouse)
(invert-face 'yelmouse)
(copy-face 'greface 'gremouse)
(invert-face 'gremouse)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; werk met adm constructie ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun new-adm () "Maak een nieuwe adm" (list "(**)" () ()))
(defun make-adm (req proof lem) "Maak een adm uit req en lem" 
  (list req proof lem))
(defun get-req (adm) "Haalt req uit een adm" (format "%s" (nth 0 adm)))
(defun get-lem (adm) "Haalt lem uit een adm" (nth 2 adm))
(defun get-proof (adm) "Haalt proof uit een adm" (nth 1 adm))
(defun get-stat (adm) "Haalt de statement uit een adm" 
  (format "%s" (nth 1 (nth 1 adm))))
(defun get-naam (adm) "Haalt naam uit proof uit adm"
  (let (proof name)
    (setq proof (get-proof adm))
    (setq name (format "%s" (nth 1 proof)))
    (if (string= name "") "" 
      (if (string= (substring name 0 1) ":") ""
      (concat (substring name 0 1) (naam-uit-verf (substring name 1)))))))

(defun add-lem-adm (adm lem) "voegt lem aan adm toe"
  (make-adm (get-req adm) (get-proof adm) 
    (append (get-lem adm) (list lem))))

(defun insert-lems (lemin lemfor adm) "Plaats lemin voor lemfor"
  (make-adm (get-req adm) (get-proof adm) 
    (insert-lem-lems lemin lemfor (get-lem adm))))

(defun insert-lem-lems (lemin lemfor lems) "Nu in de lems"
  (let (res-lems)
    (setq res-lems ())
    (while (not (equal lems ()))
      (if (equal lemfor (naam-uit-verf (nth 1 (car lems))))
        (setq res-lems (cons (car lems) (cons lemin res-lems)))
        (setq res-lems (cons (car lems) res-lems)))
      (setq lems (cdr lems)))
    (reverse res-lems)))

(defun set-req (adm req) "maakt van de reqs van adm req"
  (make-adm req (get-proof adm) (get-lem adm)))
(defun set-lem (adm lem) "maakt van de lems van adm lem"
  (make-adm (get-req adm) (get-proof adm) lem))
(defun set-proof (adm proof) "maakt de proof van adm aan"
  (make-adm (get-req adm) proof (get-lem adm)))

(defun is-lem (lem adm) "zoekt of lem een verfijning is in adm"
  (let (tmp-lems answer)
    (setq answer ())
    (setq tmp-lems (get-lem adm))
    (while (not (equal tmp-lems ()))
      (if (equal lem (format "%s" (nth 1 (car tmp-lems)))) (setq answer t))
      (setq tmp-lems (cdr tmp-lems)))
    answer))

(defun is-lem-by-name (name) "Is lem maar nu met naam"
  (let (tmp-lems answer)
    (setq answer ())
    (setq tmp-lems (get-lem current-proof-adm))
    (while (not (equal tmp-lems ()))
      (if (equal name (naam-uit-verf (format "%s" (nth 1 (car tmp-lems))))) 
        (setq answer t))
        (setq tmp-lems (cdr tmp-lems)))
    answer))

(defun naam-uit-verf (verf) "Haalt de naam uit verf"
  (if (string= verf "") "" 
    (if (string= (substring verf 0 1) ":") ""
      (concat (substring verf 0 1) (naam-uit-verf (substring verf 1))))))

(defun delete-lem (lem adm) "delete lem uit adm"
  (make-adm (get-req adm) (get-proof adm)
    (remove-lem-lems lem (get-lem current-proof-adm))))

(defun remove-lem-lems (lem lems) "remove lem uit lems"
  (let (res-lems)
    (setq res-lems ())
    (while (not (equal lems ()))
    (if (equal lem (format "%s" (nth 1 (car lems)))) ()
        (setq res-lems (cons (car lems) res-lems)))
    (setq lems (cdr lems)))
    (reverse res-lems)))

;;;;;;;;;;;;;;;;;;;
;; het afdrukken ;;
;;;;;;;;;;;;;;;;;;;

;; (defun print-lemmas (lems) "print de lemmas met kleur" (mapcar 'prilem lems))

(defun prilem (lemma) "print lemma in kleur"
  (let ((kleur (get-color lemma))
       (proof (get-prf lemma)))
  (cond ((or (equal 'rood kleur)(equal "rood" kleur)) (print-rood proof))
        ((or (equal 'geel kleur)(equal kleur "geel")) (print-geel proof))
        ((or (equal 'groen kleur)(equal kleur "groen")) (print-groen proof)))))

;; (defun print-proof (proof) "print de proof-header met kleur"
;;  (let ((kleur (get-color proof))
;;       (prf (get-prf proof)))
;;  (cond ((or (equal 'rood kleur)(equal "rood" kleur)) (print-rood prf))
;;        ((or (equal 'geel kleur)(equal kleur "geel")) (print-geel prf))
;;        ((or (equal 'groen kleur)(equal kleur "groen")) (print-groen prf))))
;;  (insert "------------------------------------")
;;  (newline)) 

(defun get-color (lemma) "pakt kleur uit lemma" (nth 0 lemma))
(defun get-prf (lemma) "pakt proof uit lemma" (format "%s" (nth 1 lemma)))

(defvar overlay-lijst () "lijst met overlays LIFO")

(defun print-rood (proof) "print proof rood"
  (let (start end)
    (setq start (point))
    (insert proof)
    (setq end (point))
    (newline)
    (add-to-list 'overlay-lijst
      (make-overlay start end)))
  (overlay-put (car overlay-lijst) 'face 'redface)
  (overlay-put (car overlay-lijst) 'mouse-face 'redmouse))

(defun print-geel (proof) "print proof geel"
  (let (start end)
    (setq start (point))
    (insert proof)
    (setq end (point))
    (newline)
    (add-to-list 'overlay-lijst
      (make-overlay start end)))
  (overlay-put (car overlay-lijst) 'face 'yelface)(print (point))
  (overlay-put (car overlay-lijst) 'mouse-face 'yelmouse))

(defun print-groen (proof) "print proof groen"
  (let (start end)
    (setq start (point))
    (insert proof)
    (setq end (point))
    (newline)
    (add-to-list 'overlay-lijst
      (make-overlay start end)))
  (overlay-put (car overlay-lijst) 'face 'greface)
  (overlay-put (car overlay-lijst) 'mouse-face 'gremouse))

;;;;;;;;;;;;;;;;;;;;;;;;;
;; afdrukken zwart-wit ;;
;;;;;;;;;;;;;;;;;;;;;;;;;

(defun print-lemmas (lems) "print de lemmas met status" 
  (mapcar 'print-lemma-zw lems))

(defun print-proof (proof) "print proof met status"
  (print-lemma-zw proof)
  (insert "-----------------------------------------")
  (newline))

(defun print-lemma-zw (lemma) "Print lemma met merk"
  (insert (format "%s" (nth 1 lemma)))
  (if (equal (format "%s" (nth 0 lemma)) "groen")
    (insert "    ABS")
    (if (equal (format "%s" (nth 0 lemma)) "geel")
      (insert "    REL")
      (insert "    TODO")))
  (newline))

(defun print-lemma (lemma diepte) "Print lemma met merk op diepte"
  (let (depth)
    (setq depth diepte)
    (while (> depth 0)
      (insert " ")
      (setq depth (- depth 1))))
  (insert (format "%s" (nth 1 lemma)))
  (if (equal (format "%s" (nth 0 lemma)) "groen")
    (insert "    ABS")
    (if (equal (format "%s" (nth 0 lemma)) "geel")
      (insert "    REL")
      (insert "    TODO")))
  (newline))

;;;;;;;;;;;;;;;;;;;;;;
;; verander kleuren ;;
;;;;;;;;;;;;;;;;;;;;;;

(defun set-color (lemma kleur lemmas) "verander de kleur van lemma"
  (let (lems lemres)
    (setq lems lemmas)
    (setq lemres ())
    (while (not (equal lems ()))
      (setq lemres (cons (set-kleur lemma kleur (car lems)) lemres))
      (setq lems (cdr lems)))
    (reverse lemres)))

(defun set-kleur (lemma-in kleur lemma-out) "verander kleur in een lemma na match"
  (if (equal (format "%s" lemma-in) (format "%s" (nth 1 lemma-out)))
    (list kleur lemma-in)
    lemma-out))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; het lezen uit een file ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defconst current-proof-adm (new-adm) "Hierin staat de adm van de huidige proof")

(defun read-adm (filenaam) "lees filenaam's administration"
  (defconst current-proof-adm (read (find-file-noselect filenaam)) 
    "Zet de cpa naar de nieuwe proof-adm"))

(defun open-bewijs-adm (bewijs) "leest een bewijs in en laat de adm zien"
  (read-adm (format "%s.adm" (get-naam bewijs)))
  (print-proof (get-proof current-proof-adm))
  (print-lemmas (get-lem current-proof-adm))
  (kill-buffer (format "%s.adm" (get-naam bewijs))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; het schrijven naar file ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar temp-buf "slaat de current-buffer even op")

(defun write-adm (filenaam adms) "schrijf administration naar file"
  (setq temp-buf (current-buffer))
  (find-file filenaam)
  (erase-buffer)
  (insert (format "%S" adms))
  (save-buffer filenaam)
  (set-buffer temp-buf)
  (kill-buffer filenaam))

(defun sluit-bewijs-adm () "makkelijker te gebruiken dan write"
  (write-adm 
    (format "%S.adm" (get-naam current-proof-adm)) 
    current-proof-adm))

;; een testje
;; (defvar ex (make-adm 1 
;;              (list (list "rood" "rood") 
;;              (list "geel" "geel")) 
;;              "k"))
;; (get-req ex)
;; (print (get-lem ex))
;; (print-lemmas (get-lem ex))
;; (defvar voorbeeld (new-adm "voorbeeld"))
;; (open-bewijs-adm (new-adm "voorbeeld"))
;; (sluit-bewijs-adm)
